// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IPopup.cs 10 2007-09-30 14:34:09Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

namespace Chattr
{
    class IPopup
    {
        private int m_Flags;
        private string m_User;
        private string m_Text;

        public IPopup()
        {
            m_Flags = 0;
            m_Text = "";
        }

        public IPopup(int flags, string user, string text)
        {
            m_Flags = flags;
            m_User = user;
            m_Text = text;
        }

        public override string ToString()
        {
            return m_User + ": " + m_Text;
        }

        public int Flags
        {
            get
            {
                return m_Flags;
            }
            set
            {
                m_Flags = value;
            }
        }

        public string User
        {
            get
            {
                return m_User;
            }
            set
            {
                m_User = value;
            }
        }

        public string Text
        {
            get
            {
                return m_Text;
            }
            set
            {
                m_Text = value;
            }
        }
    }
}
