// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: FormMain.cs 13 2007-10-04 16:00:35Z ichi $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Collections;

using System.Threading;
using System.IO;
using System.Net;
using System.Net.NetworkInformation;
using Shell32;
using agsXMPP;

using System.Diagnostics;


namespace Chattr
{
    public partial class FormMain : Form
    {
        public FormMain()
        {
            Debug.WriteLine("DEBUG");
            Debug.WriteLine(System.Reflection.Assembly.GetEntryAssembly().Location);
            Debug.WriteLine(Application.ExecutablePath);
            m_Browser = new FormBrowser(this);
            m_Popup = new FormPopup();
            m_MutexStatus = new Mutex(false);
            m_MutexSearch = new Mutex(false);
            InitializeComponent();
            m_Prefs = new FormPreferences(this);
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == Program.MsgID)
            {
                toolStripMenuItemTaskTrayIconOpen.PerformClick();
            }
            else
            {
                base.WndProc(ref m);
            }
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            m_Prefs.SetDialog();
            while ((Properties.Settings.Default.UserName == "") || (m_Prefs.Password == ""))
            {
                if (m_Prefs.ShowDialog(this) == DialogResult.OK)
                {
                    m_Prefs.GetDialog();
                    m_Prefs.Save();
                }
                else
                {
                    this.Hide();
                    Application.Exit();
                    return;
                }
            }
            if (Properties.Settings.Default.MultiLineForm)
            {
                textBoxStatus.Multiline = true;
                Point location = textBoxStatus.Location;
                location.Y -= 29;
                textBoxStatus.Location = location;
                Size size = textBoxStatus.Size;
                size.Height += 29;
                textBoxStatus.Size = size;
                size = listBoxStatuses.Size;
                size.Height -= 29;
                listBoxStatuses.Size = size;
                listBoxSearch.Size = size;
            }
            SetLocation();
            toolStripButtonRefresh.Enabled = false;
            toolStripButtonOffline.Enabled = false;
            toolStripTextBoxSearch.Enabled = false;
            toolStripSplitButtonSearch.Enabled = false;
            textBoxStatus.Enabled = false;
            comboBoxLocation.Enabled = false;
            toolStripLabelStatuses.Text = "";
            toolStripStatusLabel.Text = "";
            toolStripProgressBar.Visible = false;
            SetWindowSize();
            SetWindowTitle();
            this.SetStyle(ControlStyles.ResizeRedraw, true);
            m_ListWidth = listBoxStatuses.Width;
            NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(NetworkChange_NetworkAvailabilityChanged);
            RequestBackGround(BG_FILL);
            OpenXmpp();
        }

        private void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
        {
            if (this.InvokeRequired)
            {
                System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler dlgt =
                    new System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler(
                        NetworkChange_NetworkAvailabilityChanged);
                this.Invoke(dlgt, new object[] { sender, e });
            }
            else
            {
                if (e.IsAvailable)
                {
                    Debug.WriteLine("lbg[NڑLɂȂ܂B");
                    OpenXmpp();
                }
                else
                {
                    Debug.WriteLine("lbg[NڑɂȂ܂B");
                    CloseXmpp();
                }
            }
        }

        private void FormMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (m_fBgBusy || (m_RunGetProfileImage > 0) || (m_RunGetTinyUrl > 0))
            {
                e.Cancel = true;
                backgroundWorker.CancelAsync();
                if (m_RunGetProfileImage > 0)
                {
                    Debug.WriteLine("Runing GetProfileImage");
                }
                if (m_RunGetTinyUrl > 0)
                {
                    Debug.WriteLine("Runing GetTinyUrl");
                }
            }
            else
            {
                Quit();
            }
        }

        private void FormMain_SizeChanged(object sender, EventArgs e)
        {
            if (listBoxStatuses.Width > 0)
            {
                m_ListWidth = listBoxStatuses.Width;
            }
            if (this.WindowState == FormWindowState.Minimized)
            {
                if (Properties.Settings.Default.TaskTrayIcon)
                {
                    notifyIcon.Visible = true;
                    this.Hide();
                }
            }
            else if (this.WindowState == FormWindowState.Normal)
            {
                SaveWindowSize();
            }
        }

        private void FormMain_Move(object sender, EventArgs e)
        {
            SaveWindowPosition();
        }

        private void FormMain_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyData)
            {
                case Keys.Alt | Keys.U:
                    if (m_TblSearch != null)
                    {
                        listBoxSearch.Focus();
                    }
                    else
                    {
                        listBoxStatuses.Focus();
                    }
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.W:
                    textBoxStatus.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.L:
                    comboBoxLocation.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.S:
                    toolStripTextBoxSearch.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.P:
                    toolStripButtonPreferences.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.R:
                    toolStripButtonRefresh.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Shift | Keys.Alt | Keys.R:
                    toolStripButtonRefresh.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.O:
                    toolStripButtonOffline.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.E:
                    toolStripSplitButtonSearch.PerformButtonClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.Q:
                    toolStripSplitButtonSearch.ShowDropDown();
                    e.Handled = true;
                    break;
            }
        }

        private void listBoxStatuses_MeasureItem(object sender, MeasureItemEventArgs e)
        {
            //if (e.Index < 20)
            //{
            //    Debug.WriteLine("MeasureItem: " + e.Index + " / " + listBoxStatuses.Items.Count);
            //}
            e.ItemHeight = listBox_MeasureItem(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_DrawItem(object sender, DrawItemEventArgs e)
        {
            listBox_DrawItem(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_KeyDown(object sender, KeyEventArgs e)
        {
            listBox_KeyDown(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_DoubleClick(object sender, EventArgs e)
        {
            listBox_DoubleClick(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_SelectedIndexChanged(object sender, EventArgs e)
        {
            listBox_SelectedIndexChanged(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxSearch_MeasureItem(object sender, MeasureItemEventArgs e)
        {
            e.ItemHeight = listBox_MeasureItem(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_DrawItem(object sender, DrawItemEventArgs e)
        {
            listBox_DrawItem(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_KeyDown(object sender, KeyEventArgs e)
        {
            listBox_KeyDown(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_DoubleClick(object sender, EventArgs e)
        {
            listBox_DoubleClick(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_SelectedIndexChanged(object sender, EventArgs e)
        {
            listBox_SelectedIndexChanged(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void textBoxStatus_Enter(object sender, EventArgs e)
        {
            if (textBoxStatus.ForeColor == Color.FromKnownColor(KnownColor.GrayText))
            {
                textBoxStatus.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
                textBoxStatus.Text = "";
            }
        }

        private void textBoxStatus_Leave(object sender, EventArgs e)
        {
            if (textBoxStatus.Text == "")
            {
                textBoxStatus.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
                textBoxStatus.Text = "What are you doing?";
            }
        }

        private void textBoxStatus_EnabledChanged(object sender, EventArgs e)
        {
            if (!textBoxStatus.Enabled)
            {
                listBoxStatuses.Focus();
            }
        }

        private void textBoxStatus_TextChanged(object sender, EventArgs e)
        {
            int length = 0;
            if (textBoxStatus.ForeColor != Color.FromKnownColor(KnownColor.GrayText))
            {
                length = textBoxStatus.Text.Length;
                if (Properties.Settings.Default.UseSignature && (Properties.Settings.Default.Signature != ""))
                {
                    length += Properties.Settings.Default.Signature.Length + 1;
                }
                if (comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.Gray))
                {
                    length += comboBoxLocation.Text.Length;
                }
            }
            labelAvailable.Text = LABEL_AVAILABLE + (140 - length);
        }

        private void textBoxStatus_KeyDown(object sender, KeyEventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            if (m_TblSearch != null)
            {
                listBox = listBoxSearch;
            }
            switch (e.KeyData)
            {
                case Keys.Home | Keys.Control:
                    listBox.SelectedIndex = 0;
                    e.Handled = true;
                    break;
                case Keys.End | Keys.Control:
                    listBox.SelectedIndex = listBox.Items.Count - 1;
                    e.Handled = true;
                    break;
                case Keys.Down:
                    if (listBox.SelectedIndex < listBox.Items.Count - 1)
                    {
                        listBox.SelectedIndex += 1;
                    }
                    e.Handled = true;
                    break;
                case Keys.Up:
                    if (listBox.SelectedIndex > 0)
                    {
                        listBox.SelectedIndex -= 1;
                    }
                    e.Handled = true;
                    break;
            }
        }

        private void textBoxStatus_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (textBoxStatus.Text != "")
                {
                    string text = textBoxStatus.Text;
                    if (Properties.Settings.Default.UseSignature && (Properties.Settings.Default.Signature != ""))
                    {
                        text += " " + Properties.Settings.Default.Signature;
                    }
                    if ((comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText)) && (comboBoxLocation.Text != ""))
                    {
                        text += " L:" + comboBoxLocation.Text;
                    }
                    textBoxStatus.Enabled = false;
                    UpdateStatus(text);
                }
                else
                {
                    toolStripButtonRefresh_Click(sender, e);
                }
                e.Handled = true;
            }
        }

        private void comboBoxLocation_Enter(object sender, EventArgs e)
        {
            if (comboBoxLocation.ForeColor == Color.FromKnownColor(KnownColor.GrayText))
            {
                comboBoxLocation.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
                comboBoxLocation.Text = "";
            }
        }

        private void comboBoxLocation_Leave(object sender, EventArgs e)
        {
            if (comboBoxLocation.Text == "")
            {
                comboBoxLocation.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
                comboBoxLocation.Text = "Location";
            }
        }

        private void toolStripButtonPreferences_Click(object sender, EventArgs e)
        {
            bool useXmpp = Properties.Settings.Default.UseXmpp;
            if (m_Prefs.ShowDialog(this) == DialogResult.OK)
            {
                m_Prefs.GetDialog();
                listBoxSearch.BeginUpdate();
                listBoxSearch.EndUpdate();
                listBoxStatuses.BeginUpdate();
                listBoxStatuses.EndUpdate();
                SetWindowTitle();
                if (useXmpp != Properties.Settings.Default.UseXmpp)
                {
                    if (useXmpp)
                    {
                        CloseXmpp();
                    }
                    else if (toolStripButtonOffline.CheckState == CheckState.Unchecked)
                    {
                        OpenXmpp();
                    }
                }
            }
            else
            {
                m_Prefs.SetDialog();
            }
        }

        private void toolStripButtonRefresh_Click(object sender, EventArgs e)
        {
            if ((ModifierKeys & Keys.Shift) == 0)
            {
                GetFollowingTimeline();
                if (Properties.Settings.Default.RefreshWithReplies)
                {
                    GetReplies();
                }
            }
            else
            {
                GetReplies();
            }
        }

        private void toolStripButtonOffline_Click(object sender, EventArgs e)
        {
            if (toolStripButtonOffline.CheckState == CheckState.Unchecked)
            {
                toolStripButtonOffline.CheckState = CheckState.Checked;
                toolStripButtonOffline.ToolTipText = "IC(O)";
                m_TimeOfflineIn = DateTime.Now;
                CloseXmpp();
            }
            else
            {
                toolStripButtonOffline.CheckState = CheckState.Unchecked;
                toolStripButtonOffline.ToolTipText = "ItC(O)";
                DateTime now = DateTime.Now;
                m_SpanOfflineFollowing += now - m_TimeOfflineIn;
                m_SpanOfflineReplies += now - m_TimeOfflineIn;
                OpenXmpp();
                Debug.WriteLine("Offline following: " + m_SpanOfflineFollowing);
                Debug.WriteLine("Offline replies: " + m_SpanOfflineReplies);
            }
        }

        private void toolStripMenuItemStatusesReply_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            EntryReply(listBox, e, table, mutex);
        }

        private void toolStripMenuItemStatusesDirect_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            EntryDirectMessage(listBox, e, table, mutex);
        }

        private void toolStripMenuItemStatusesFavorite_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            Favorite(listBox, e, table, mutex);
        }

        private void toolStripMenuItemStatusReblog_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            Reblog(listBox, e, table, mutex);
        }

        private void backgroundWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = (BackgroundWorker)sender;
            if (e.Argument.GetType() == typeof(String))
            {
                e.Result = DoBackGround_String((String)e.Argument, worker);
            }
            else if (e.Argument.GetType() == typeof(agsXMPP.protocol.client.Message))
            {
                e.Result = DoBackGround_XmppMessage((agsXMPP.protocol.client.Message)e.Argument, worker);
            }
            if ((e.Result == null) && worker.CancellationPending)
            {
                e.Cancel = true;
            }
        }

        private void backgroundWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            try
            {
                switch ((ProgressOp)e.ProgressPercentage)
                {
                    case ProgressOp.BG_FLAG:
                        if (e.UserState.GetType() == typeof(bool))
                        {
                            m_fBgFlag = (bool)e.UserState;
                        }
                        break;
                    case ProgressOp.STATUS_BAR:
                        if (e.UserState.GetType() == typeof(String))
                        {
                            SetToolStripStatusLabelText((String)e.UserState);
                        }
                        break;
                    case ProgressOp.LABEL_STATUS:
                        if (e.UserState.GetType() == typeof(String))
                        {
                            toolStripLabelStatuses.Text = (String)e.UserState;
                        }
                        break;
                    case ProgressOp.PROGRESS_BAR:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            toolStripProgressBar.Value = (int)e.UserState;
                            if ((int)e.UserState == 100)
                            {
                                toolStripProgressBar.Visible = false;
                            }
                            else
                            {
                                toolStripProgressBar.Visible = true;
                            }
                        }
                        break;
                    case ProgressOp.NUM_STATUS:
                        toolStripLabelStatuses.Text = NumStatus();
                        break;
                    case ProgressOp.LIST_ENABLE:
                        listBoxSearch.TabStop = false;
                        listBoxSearch.Visible = false;
                        listBoxStatuses.TabStop = true;
                        listBoxStatuses.Visible = true;
                        break;
                    case ProgressOp.LIST_BEGIN_UPDATE:
                        listBoxStatuses.BeginUpdate();
                        break;
                    case ProgressOp.LIST_END_UPDATE:
                        listBoxStatuses.EndUpdate();
                        break;
                    case ProgressOp.LIST_ADD:
                        if (e.UserState.GetType() == typeof(IListItem))
                        {
                            listBoxStatuses.Items.Add(e.UserState);
                            //Debug.WriteLineIf(m_Loading >= m_Load, "LIST_ADD: " + ((IListItem)e.UserState).Index + " / " + ((IListItem)e.UserState).Id);
                        }
                        break;
                    case ProgressOp.LIST_INSERT:
                        if (e.UserState.GetType() == typeof(IListItem))
                        {
                            listBoxStatuses.Items.Insert(((IListItem)e.UserState).Index, e.UserState);
                            //Debug.WriteLineIf(m_Loading >= m_Load, "LIST_INSERT: " + ((IListItem)e.UserState).Index + " / " + ((IListItem)e.UserState).Id);
                        }
                        break;
                    case ProgressOp.LIST_REPLACE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            IListItem item = new IListItem((IListItem)listBoxStatuses.Items[(int)e.UserState]);
                            item.Value++;
                            listBoxStatuses.Items[(int)e.UserState] = item;
                        }
                        break;
                    case ProgressOp.LIST_DELETE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            ((IListItem)listBoxStatuses.Items[(int)e.UserState]).Delete = true;
                            //Debug.WriteLineIf(m_Loading >= m_Load, "LIST_DELETE: " +(int)e.UserState);
                        }
                        break;
                    case ProgressOp.LIST_REMOVE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            listBoxStatuses.Items.RemoveAt((int)e.UserState);
                        }
                        break;
                    case ProgressOp.LIST_REMOVES:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            for (int i = 0; i < (int)e.UserState; i++)
                            {
                                for (int idx = 0; idx < listBoxStatuses.Items.Count; idx++)
                                {
                                    if (((IListItem)listBoxStatuses.Items[idx]).Delete)
                                    {
                                        listBoxStatuses.Items.RemoveAt(idx);
                                        break;
                                    }
                                }
                            }
                        }
                        break;
                    case ProgressOp.LIST_SELECT:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            int index = (int)e.UserState;
                            if (index >= listBoxStatuses.Items.Count)
                            {
                                index = 0;
                            }
                            listBoxStatuses.SelectedIndex = index;
                        }
                        break;
                    case ProgressOp.LIST_CLEAR:
                        listBoxStatuses.Items.Clear();
                        break;
                    case ProgressOp.LIST_SEARCH_BEGIN_UPDATE:
                        listBoxSearch.BeginUpdate();
                        break;
                    case ProgressOp.LIST_SEARCH_END_UPDATE:
                        listBoxSearch.EndUpdate();
                        break;
                    case ProgressOp.LIST_SEARCH_ADD:
                        if (e.UserState.GetType() == typeof(IListItem))
                        {
                            listBoxSearch.Items.Add(e.UserState);
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_INSERT:
                        if (e.UserState.GetType() == typeof(IListItem))
                        {
                            listBoxSearch.Items.Insert(((IListItem)e.UserState).Index, e.UserState);
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_REPLACE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            ((IListItem)listBoxSearch.Items[(int)e.UserState]).Value++;
                            listBoxSearch.Items[(int)e.UserState] = new IListItem((IListItem)listBoxSearch.Items[(int)e.UserState]);
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_DELETE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            ((IListItem)listBoxSearch.Items[(int)e.UserState]).Delete = true;
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_REMOVE:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            listBoxSearch.Items.RemoveAt((int)e.UserState);
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_REMOVES:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            for (int i = 0; i < (int)e.UserState; i++)
                            {
                                for (int idx = 0; idx < listBoxSearch.Items.Count; idx++)
                                {
                                    if (((IListItem)listBoxSearch.Items[idx]).Delete)
                                    {
                                        listBoxSearch.Items.RemoveAt(idx);
                                        break;
                                    }
                                }
                            }
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_SELECT:
                        if (e.UserState.GetType() == typeof(int))
                        {
                            int index = (int)e.UserState;
                            if (index >= listBoxSearch.Items.Count)
                            {
                                index = 0;
                            }
                            listBoxSearch.SelectedIndex = index;
                        }
                        break;
                    case ProgressOp.LIST_SEARCH_CLEAR:
                        listBoxSearch.Items.Clear();
                        break;
                }
            }
            catch (SystemException ex)
            {
                Debug.WriteLine("backgroundWorker_ProgressChanged() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
        }

        private void backgroundWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Cancelled)
            {
                m_fBgBusy = false;
                Close();
            }
            else
            {
                if (e.Result != null)
                {
                    if (e.Result.GetType() == typeof(IResultXmppMessage))
                    {
                        IResultXmppMessage result = e.Result as IResultXmppMessage;
                        NotifyFlash(result);
                    }
                    else if (e.Result.GetType() == typeof(IResultGetReplies))
                    {
                        IResultGetReplies result = e.Result as IResultGetReplies;
                        StartRepliesTimer(DateTime.Now);
                        NotifyFlash(result);
                    }
                    else if (e.Result.GetType() == typeof(IResultGetFollowing))
                    {
                        IResultGetFollowing result = e.Result as IResultGetFollowing;
                        StartFollowingTimer(DateTime.Now);
                        NotifyFlash(result);
                    }
                    else if (e.Result.GetType() == typeof(IResultUpdate))
                    {
                        IResultUpdate result = e.Result as IResultUpdate;
                        if (result.Success)
                        {
                            textBoxStatus.Text = "";
                        }
                        textBoxStatus.Enabled = true;
                        textBoxStatus.Focus();
                    }
                    else if (e.Result.GetType() == typeof(IResultInit))
                    {
                        if (Properties.Settings.Default.RetrieveStartup)
                        {
                            GetFollowingTimeline();
                            GetReplies();
                        }
                        else
                        {
                            StartTimer();
                        }
                        toolStripButtonRefresh.Enabled = true;
                        toolStripButtonOffline.Enabled = true;
                        toolStripTextBoxSearch.Enabled = true;
                        toolStripSplitButtonSearch.Enabled = true;
                        textBoxStatus.Enabled = true;
                        comboBoxLocation.Enabled = true;
                    }
                    else if (e.Result.GetType() == typeof(IResultLoadFin))
                    {
                    }
                }
                if (m_Loading < m_TableStatusRows)
                {
                    RequestLoad();
                }
                if (ArrayList.Synchronized(m_BgWork).Count != 0)
                {
                    ArrayList.Synchronized(m_BgWork).RemoveAt(0);
                }
                if (ArrayList.Synchronized(m_BgWork).Count != 0)
                {
                    backgroundWorker.RunWorkerAsync(ArrayList.Synchronized(m_BgWork)[0]);
                }
                else
                {
                    m_fBgBusy = false;
                }
            }
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            if (!toolStripButtonOffline.Checked)
            {
                DateTime now = DateTime.Now;
                TimeSpan span = now - m_TimeFollowing - m_SpanOfflineFollowing;
                if (m_fEnableFollowing &&
                    (Properties.Settings.Default.IntervalFriends > 0) &&
                    (span.TotalMinutes >= Properties.Settings.Default.IntervalFriends))
                {
                    GetFollowingTimeline();
                }
                else if (m_fEnableFollowing)
                {
                    TimeSpan interval = new TimeSpan((long)Properties.Settings.Default.IntervalFriends * 10000000 * 60);
                    span = (m_TimeFollowing + interval) - now + m_SpanOfflineFollowing;
                    if ((span.TotalMinutes >= 1) && (span.Seconds == 0) && (span.TotalMinutes != m_SpanFollowing.TotalMinutes))
                    {
                        m_SpanFollowing = span;
                        SetToolStripStatusLabelText("Following ^CC擾܂ŁA " + span.Minutes + " ");
                    }
                    else if ((span.TotalMinutes < 1) && (span.TotalSeconds != m_SpanFollowing.TotalSeconds))
                    {
                        m_SpanFollowing = span;
                        if ((span.Seconds == 29) ||
                            (span.Seconds == 19) ||
                            (span.Seconds == 14) ||
                            (span.Seconds < 10))
                            SetToolStripStatusLabelText("Following ^CC擾܂ŁA  " + (span.Seconds + 1) + " b");
                    }
                }
                span = now - m_TimeReplies - m_SpanOfflineReplies;
                if (m_fEnableReplies &&
                    (Properties.Settings.Default.IntervalReplies > 0) &&
                    (span.TotalMinutes >= Properties.Settings.Default.IntervalReplies))
                {
                    GetReplies();
                }
            }
        }

        private void toolStripTextBoxSearch_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                toolStripSplitButtonSearch.PerformButtonClick();
            }
        }

        private void toolStripSplitButtonSearch_ButtonClick(object sender, EventArgs e)
        {
            m_MutexSearch.WaitOne();
            try
            {
                if (toolStripTextBoxSearch.Text == "")
                {
                    if (m_TblSearch != null)
                    {
                        m_TblSearch = null;
                    }
                }
                else
                {
                    m_Search = "%" + toolStripTextBoxSearch.Text + "%";
                    if (toolStripMenuItemLocation.Checked)
                    {
                        m_Search = "%L:" + toolStripTextBoxSearch.Text + "%";
                    }
                    m_TblSearch = SearchStatus(m_Search);
                    if (m_TblSearch != null)
                    {
                        int cnt = m_TblSearch.Rows.Count;
                        if (cnt == 0)
                        {
                            m_TblSearch = null;
                        }
                        else
                        {
                            listBoxSearch.BeginUpdate();
                            listBoxSearch.Items.Clear();
                            foreach (DataSetChattr.TableStatusRow row in m_TblSearch.Rows)
                            {
                                listBoxSearch.Items.Add(new IListItem(row.id, 0));
                            }
                            listBoxSearch.SelectedIndex = 0;
                            listBoxSearch.EndUpdate();
                        }
                    }
                }
                if (m_TblSearch != null)
                {
                    listBoxStatuses.TabStop = false;
                    listBoxStatuses.Visible = false;
                    listBoxSearch.TabStop = true;
                    listBoxSearch.Visible = true;
                }
                else
                {
                    listBoxSearch.TabStop = false;
                    listBoxSearch.Visible = false;
                    listBoxStatuses.TabStop = true;
                    listBoxStatuses.Visible = true;
                }
                toolStripLabelStatuses.Text = NumStatus();
            }
            catch (SystemException ex)
            {
                Debug.WriteLine("toolStripSplitButtonSearch_ButtonClick() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            finally
            {
                m_MutexSearch.ReleaseMutex();
            }
        }

        private void toolStripMenuItemAll_Click(object sender, EventArgs e)
        {
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemAll.Checked = true;
            toolStripMenuItemAll.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemUser_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemUser.Checked = true;
            toolStripMenuItemUser.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemStatus_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemStatus.Checked = true;
            toolStripMenuItemStatus.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemLocation_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemLocation.Checked = true;
            toolStripMenuItemLocation.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemSource_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = true;
            toolStripMenuItemSource.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemLocationAdd_Click(object sender, EventArgs e)
        {
            if ((comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText)) && (comboBoxLocation.Text != ""))
            {
                bool add = true;
                foreach (string location in comboBoxLocation.Items)
                {
                    if (location == comboBoxLocation.Text)
                    {
                        add = false;
                        break;
                    }
                }
                if (add)
                {
                    comboBoxLocation.Items.Add(comboBoxLocation.Text);
                }
            }
        }

        private void toolStripMenuItemLocationDelete_Click(object sender, EventArgs e)
        {
            if (comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText))
            {
                foreach (string location in comboBoxLocation.Items)
                {
                    if (location == comboBoxLocation.Text)
                    {
                        comboBoxLocation.Items.Remove(comboBoxLocation.Text);
                        break;
                    }
                }
            }
        }

        private void notifyIcon_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            toolStripMenuItemTaskTrayIconOpen.PerformClick();
        }

        private void toolStripMenuItemTaskTrayIconOpen_Click(object sender, EventArgs e)
        {
            this.Show();
            this.WindowState = FormWindowState.Normal;
            this.Activate();
            notifyIcon.Visible = false;
        }

        private void toolStripMenuItemTaskTrayIconPreferences_Click(object sender, EventArgs e)
        {
            toolStripButtonPreferences.PerformClick();
        }

        private void toolStripMenuItemTaskTrayIconRefresh_Click(object sender, EventArgs e)
        {
            toolStripButtonRefresh.PerformClick();
        }

        private void toolStripMenuItemTaskTrayIconOffline_Click(object sender, EventArgs e)
        {
            toolStripButtonOffline.PerformClick();
        }

        private void toolStripMenuItemTaskTrayIconQuit_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void contextMenuStripStatuses_Opening(object sender, CancelEventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxSearch;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            int idx = listBox.SelectedIndex;
            if ((idx >= 0) && (idx < listBox.Items.Count))
            {
                mutex.WaitOne();
                try
                {
                    DataSetChattr.TableStatusRow row = table.Rows[idx] as DataSetChattr.TableStatusRow;
                    if (row.RowState != DataRowState.Deleted)
                    {
                        StatusParser parser = new StatusParser(row.text);
                        contextMenuStripStatusesMake(row, parser);
                    }
                }
                catch (SystemException ex)
                {
                    Debug.WriteLine("contextMenuStripStatuses_Opening() Error\n" +
                        ex.Message + "\n" + "Source: " + ex.Source);
                }
                finally
                {
                    mutex.ReleaseMutex();
                }
            }
        }
    }
}