// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: SQLite.cs 3 2007-09-26 13:31:53Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

using System.Text.RegularExpressions;
using System.Data.SQLite;

namespace Chattr
{
    static class SQLite
    {
        static public void CreateDB(string dir)
        {
            try
            {
                string source = Regex.Replace(Properties.Settings.Default.ConnectionStringChattr, @"data source\=\""", "data source=\"" + dir);
                Console.WriteLine("SQLite.CreateDB(" + dir + "): " + source);
                using (SQLiteConnection cnn = new SQLiteConnection(source))
                using (SQLiteCommand cmd = cnn.CreateCommand())
                {
                    try
                    {
                        cnn.Open();
                    }
                    catch (SystemException ex)
                    {
                        Console.WriteLine("cnn.Open() Error\n" +
                            "in SQLite.CreateDB()\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }

                    try
                    {
                        // TableStatus̍쐬
                        cmd.CommandText = "CREATE TABLE TableStatus(id bigint PRIMARY KEY, created_at datetime, text varchar, source varchar, source_url varchar, user_id bigint, user_name varchar, user_screen_name varchar, user_location varchar, user_profile_image varchar, flags int)";
                        cmd.ExecuteNonQuery(); // Create the table, don't expect returned data
                    }
                    catch (SystemException ex)
                    {
                        Console.WriteLine("CREATE TABLE TableStatus() Error\n" +
                            "in SQLite.CreateDB()\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }

                    try
                    {
                        // TableProfileImage̍쐬
                        cmd.CommandText = "CREATE TABLE TableProfileImage(url varchar PRIMARY KEY, image varbinary, width int, height int)";
                        cmd.ExecuteNonQuery(); // Create the table, don't expect returned data
                    }
                    catch (SystemException ex)
                    {
                        Console.WriteLine("CREATE TABLE TableProfileImage() Error\n" +
                            "in SQLite.CreateDB()\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }

                    try
                    {
                        // TableTinyUrl̍쐬
                        cmd.CommandText = "CREATE TABLE TableTinyUrl(tiny varchar PRIMARY KEY, url varchar)";
                        cmd.ExecuteNonQuery(); // Create the table, don't expect returned data
                    }
                    catch (SystemException ex)
                    {
                        Console.WriteLine("CREATE TABLE TableTinyUrl() Error\n" +
                            "in SQLite.CreateDB()\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }
                }
            }
            catch (SystemException ex)
            {
                Console.WriteLine("SQLite.CreateDB() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
        }
    }
}
