// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: FormMain.cs 3 2007-09-26 13:31:53Z ichi $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Collections;

using System.Threading;
using System.IO;
using System.Net;
using System.Net.NetworkInformation;
using Shell32;
using agsXMPP;


namespace Chattr
{
    public partial class FormMain : Form
    {
        public FormMain()
        {
            Console.WriteLine(System.Reflection.Assembly.GetEntryAssembly().Location);
            Console.WriteLine(Application.ExecutablePath);
            Console.WriteLine(System.IO.Path.GetDirectoryName(Application.ExecutablePath));
            SQLite.CreateDB(System.IO.Path.GetDirectoryName(Application.ExecutablePath) + @"\..\");
            string dir = Directory.GetCurrentDirectory();
            Directory.SetCurrentDirectory(dir + @"\..");
            m_Browser = new FormBrowser(this);
            m_MutexStatus = new Mutex(false);
            m_MutexSearch = new Mutex(false);
            InitializeComponent();
            m_Prefs = new FormPreferences(this);
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            m_Prefs.SetDialog();
            while ((Properties.Settings.Default.UserName == "") || (m_Prefs.Password == ""))
            {
                if (m_Prefs.ShowDialog(this) == DialogResult.OK)
                {
                    m_Prefs.GetDialog();
                    m_Prefs.Save();
                }
                else
                {
                    this.Hide();
                    Application.Exit();
                    return;
                }
            }
            if (Properties.Settings.Default.MultiLineForm)
            {
                textBoxStatus.Multiline = true;
                Point location = textBoxStatus.Location;
                location.Y -= 29;
                textBoxStatus.Location = location;
                Size size = textBoxStatus.Size;
                size.Height += 29;
                textBoxStatus.Size = size;
                size = listBoxStatuses.Size;
                size.Height -= 29;
                listBoxStatuses.Size = size;
                listBoxSearch.Size = size;
            }
            SetLocation();
            toolStripButtonRefresh.Enabled = false;
            toolStripButtonOffline.Enabled = false;
            toolStripTextBoxSearch.Enabled = false;
            toolStripSplitButtonSearch.Enabled = false;
            textBoxStatus.Enabled = false;
            comboBoxLocation.Enabled = false;
            toolStripLabelStatuses.Text = "";
            toolStripStatusLabel.Text = "";
            toolStripProgressBar.Visible = false;
            this.Location = Properties.Settings.Default.FormMainLocation;
            this.Size = Properties.Settings.Default.FormMainSize;
            SetTitle();
            NetworkChange.NetworkAvailabilityChanged += new NetworkAvailabilityChangedEventHandler(NetworkChange_NetworkAvailabilityChanged);
            RequestBackGround("fill");
        }

        private void NetworkChange_NetworkAvailabilityChanged(object sender, NetworkAvailabilityEventArgs e)
        {
            if (this.InvokeRequired)
            {
                System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler dlgt =
                    new System.Net.NetworkInformation.NetworkAvailabilityChangedEventHandler(
                        NetworkChange_NetworkAvailabilityChanged);
                this.Invoke(dlgt, new object[] { sender, e });
            }
            else
            {
                if (e.IsAvailable)
                {
                    Console.WriteLine("lbg[NڑLɂȂ܂B");
                    OpenXmpp();
                }
                else
                {
                    Console.WriteLine("lbg[NڑɂȂ܂B");
                    CloseXmpp();
                }
            }
        }

        private void FormMain_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (m_fBgBusy)
            {
                backgroundWorker.CancelAsync();
                e.Cancel = true;
            }
            else
            {
                Quit();
            }
        }

        private void FormMain_SizeChanged(object sender, EventArgs e)
        {
            if (dataSetChattr.TableStatus != null)
            {
                if (m_MutexStatus.WaitOne(0, false))
                {
                    try
                    {
                        Invalidate(listBoxStatuses.Bounds);
                    }
                    catch (System.Exception ex)
                    {
                        Console.WriteLine("FormMain_SizeChanged() Error\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }
                    finally
                    {
                        m_MutexStatus.ReleaseMutex();
                    }
                }
                if (m_TblSearch != null)
                {
                    if (m_MutexSearch.WaitOne(0, false))
                    {
                        try
                        {
                            Invalidate(listBoxSearch.Bounds);
                        }
                        catch (System.Exception ex)
                        {
                            Console.WriteLine("FormMain_SizeChanged() Error\n" +
                                ex.Message + "\n" + "Source: " + ex.Source);
                        }
                        finally
                        {
                            m_MutexSearch.ReleaseMutex();
                        }
                    }
                }
            }
        }

        private void FormMain_KeyDown(object sender, KeyEventArgs e)
        {
            switch (e.KeyData)
            {
                case Keys.Alt | Keys.U:
                    if (m_TblSearch != null)
                    {
                        listBoxSearch.Focus();
                    }
                    else
                    {
                        listBoxStatuses.Focus();
                    }
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.W:
                    textBoxStatus.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.L:
                    comboBoxLocation.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.S:
                    toolStripTextBoxSearch.Focus();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.P:
                    toolStripButtonPreferences.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.R:
                    toolStripButtonRefresh.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.O:
                    toolStripButtonOffline.PerformClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.E:
                    toolStripSplitButtonSearch.PerformButtonClick();
                    e.Handled = true;
                    break;
                case Keys.Alt | Keys.Q:
                    toolStripSplitButtonSearch.ShowDropDown();
                    e.Handled = true;
                    break;
            }
        }

        private void listBoxStatuses_MeasureItem(object sender, MeasureItemEventArgs e)
        {
            //if (e.Index < 20)
            //{
            //    Console.WriteLine("MeasureItem: " + e.Index + " / " + listBoxStatuses.Items.Count);
            //}
            e.ItemHeight = listBox_MeasureItem(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_DrawItem(object sender, DrawItemEventArgs e)
        {
            listBox_DrawItem(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_KeyDown(object sender, KeyEventArgs e)
        {
            listBox_KeyDown(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_DoubleClick(object sender, EventArgs e)
        {
            listBox_DoubleClick(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxStatuses_SelectedIndexChanged(object sender, EventArgs e)
        {
            listBox_SelectedIndexChanged(listBoxStatuses, e, dataSetChattr.TableStatus, m_MutexStatus);
        }

        private void listBoxSearch_MeasureItem(object sender, MeasureItemEventArgs e)
        {
            e.ItemHeight = listBox_MeasureItem(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_DrawItem(object sender, DrawItemEventArgs e)
        {
            listBox_DrawItem(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_KeyDown(object sender, KeyEventArgs e)
        {
            listBox_KeyDown(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_DoubleClick(object sender, EventArgs e)
        {
            listBox_DoubleClick(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void listBoxSearch_SelectedIndexChanged(object sender, EventArgs e)
        {
            listBox_SelectedIndexChanged(listBoxSearch, e, m_TblSearch, m_MutexSearch);
        }

        private void textBoxStatus_Enter(object sender, EventArgs e)
        {
            if (textBoxStatus.ForeColor == Color.FromKnownColor(KnownColor.GrayText))
            {
                textBoxStatus.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
                textBoxStatus.Text = "";
            }
        }

        private void textBoxStatus_Leave(object sender, EventArgs e)
        {
            if (textBoxStatus.Text == "")
            {
                textBoxStatus.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
                textBoxStatus.Text = "What are you doing?";
            }
        }

        private void textBoxStatus_EnabledChanged(object sender, EventArgs e)
        {
            if (!textBoxStatus.Enabled)
            {
                listBoxStatuses.Focus();
            }
        }

        private void textBoxStatus_TextChanged(object sender, EventArgs e)
        {
            int length = 0;
            if (textBoxStatus.ForeColor != Color.FromKnownColor(KnownColor.GrayText))
            {
                length = textBoxStatus.Text.Length;
                if (Properties.Settings.Default.UseSignature && (Properties.Settings.Default.Signature != ""))
                {
                    length += Properties.Settings.Default.Signature.Length + 1;
                }
                if (comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.Gray))
                {
                    length += comboBoxLocation.Text.Length;
                }
            }
            labelAvailable.Text = LABEL_AVAILABLE + (140 - length);
        }

        private void textBoxStatus_KeyDown(object sender, KeyEventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            if (m_TblSearch != null)
            {
                listBox = listBoxSearch;
            }
            switch (e.KeyData)
            {
                case Keys.Home | Keys.Control:
                    listBox.SelectedIndex = 0;
                    e.Handled = true;
                    break;
                case Keys.End | Keys.Control:
                    listBox.SelectedIndex = listBox.Items.Count - 1;
                    e.Handled = true;
                    break;
                case Keys.Down:
                    if (listBox.SelectedIndex < listBox.Items.Count - 1)
                    {
                        listBox.SelectedIndex += 1;
                    }
                    e.Handled = true;
                    break;
                case Keys.Up:
                    if (listBox.SelectedIndex > 0)
                    {
                        listBox.SelectedIndex -= 1;
                    }
                    e.Handled = true;
                    break;
            }
        }

        private void textBoxStatus_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                if (textBoxStatus.Text != "")
                {
                    string text = textBoxStatus.Text;
                    if (Properties.Settings.Default.UseSignature && (Properties.Settings.Default.Signature != ""))
                    {
                        text += " " + Properties.Settings.Default.Signature;
                    }
                    if ((comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText)) && (comboBoxLocation.Text != ""))
                    {
                        text += " L:" + comboBoxLocation.Text;
                    }
                    textBoxStatus.Enabled = false;
                    UpdateStatus(text);
                }
                else
                {
                    toolStripButtonRefresh_Click(sender, e);
                }
                e.Handled = true;
            }
        }

        private void comboBoxLocation_Enter(object sender, EventArgs e)
        {
            if (comboBoxLocation.ForeColor == Color.FromKnownColor(KnownColor.GrayText))
            {
                comboBoxLocation.ForeColor = Color.FromKnownColor(KnownColor.WindowText);
                comboBoxLocation.Text = "";
            }
        }

        private void comboBoxLocation_Leave(object sender, EventArgs e)
        {
            if (comboBoxLocation.Text == "")
            {
                comboBoxLocation.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
                comboBoxLocation.Text = "Location";
            }
        }

        private void toolStripButtonPreferences_Click(object sender, EventArgs e)
        {
            bool useXmpp = Properties.Settings.Default.UseXmpp;
            if (m_Prefs.ShowDialog(this) == DialogResult.OK)
            {
                m_Prefs.GetDialog();
                listBoxSearch.BeginUpdate();
                listBoxSearch.EndUpdate();
                listBoxStatuses.BeginUpdate();
                listBoxStatuses.EndUpdate();
                SetTitle();
                if (useXmpp != Properties.Settings.Default.UseXmpp)
                {
                    if (useXmpp)
                    {
                        CloseXmpp();
                    }
                    else if (toolStripButtonOffline.CheckState == CheckState.Unchecked)
                    {
                        OpenXmpp();
                    }
                }
            }
            else
            {
                m_Prefs.SetDialog();
            }
        }

        private void toolStripButtonRefresh_Click(object sender, EventArgs e)
        {
            GetFriendsTimeline();
            if (Properties.Settings.Default.RefreshWithReplies)
            {
                GetReplies();
            }
        }

        private void toolStripButtonOffline_Click(object sender, EventArgs e)
        {
            if (toolStripButtonOffline.CheckState == CheckState.Unchecked)
            {
                toolStripButtonOffline.CheckState = CheckState.Checked;
                toolStripButtonOffline.ToolTipText = "IC(O)";
                m_TimeOfflineIn = DateTime.Now;
                CloseXmpp();
            }
            else
            {
                toolStripButtonOffline.CheckState = CheckState.Unchecked;
                toolStripButtonOffline.ToolTipText = "ItC(O)";
                DateTime now = DateTime.Now;
                m_SpanOfflineFriends += now - m_TimeOfflineIn;
                m_SpanOfflineReplies += now - m_TimeOfflineIn;
                OpenXmpp();
                Console.WriteLine("Offline friends: " + m_SpanOfflineFriends);
                Console.WriteLine("Offline replies: " + m_SpanOfflineReplies);
            }
        }

        private void contextMenuStripStatuses_Opening(object sender, CancelEventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxSearch;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            int idx = listBox.SelectedIndex;
            while (contextMenuStripStatuses.Items.Count > 4)
            {
                contextMenuStripStatuses.Items.RemoveAt(4);
            }
            if (table != null)
            {
                if (mutex.WaitOne(0, false))
                {
                    try
                    {
                        if ((idx >= 0) && (idx < listBox.Items.Count))
                        {
                            DataSetChattr.TableStatusRow row = table.Rows[idx] as DataSetChattr.TableStatusRow;
                            long id = row.id;
                            if (id >= 0)
                            {
                                toolStripMenuItemStatusesFavorite.Enabled = true;
                            }
                            else
                            {
                                toolStripMenuItemStatusesFavorite.Enabled = false;
                            }
                            // User
                            contextMenuStripStatuses.Items.Add(new ToolStripSeparator());
                            string owner = row.user_screen_name;
                            if ((row.user_name != "") && (row.user_name != row.user_screen_name))
                            {
                                owner += " / " + row.user_name;
                            }
                            ToolStripMenuItem item = new ToolStripMenuItem(owner);
                            item.Click += new EventHandler(contextMenuStripStatusesUser_Click);
                            contextMenuStripStatuses.Items.Add(item);
                            if (row.id >= 0)
                            {
                                item = new ToolStripMenuItem("http://twitter.com/" + row.user_screen_name + "/statuses/" + row.id);
                                item.Click += new EventHandler(contextMenuStripStatusesLink_Click);
                                contextMenuStripStatuses.Items.Add(item);
                            }
                            StatusParser parser = new StatusParser(row.text);
                            string[] users = parser.Users;
                            if (users != null)
                            {
                                contextMenuStripStatuses.Items.Add(new ToolStripSeparator());
                                foreach (string user in users)
                                {
                                    item = new ToolStripMenuItem(user);
                                    item.Click += new EventHandler(contextMenuStripStatusesUser_Click);
                                    contextMenuStripStatuses.Items.Add(item);
                                    Console.WriteLine("user: " + user);
                                }
                            }
                            // Link
                            string[] urls = parser.URLs;
                            if (urls != null)
                            {
                                contextMenuStripStatuses.Items.Add(new ToolStripSeparator());
                                foreach (string url in urls)
                                {
                                    string u = url;
                                    Image img = null;
                                    Regex r = new Regex(REGEX_TINYURL);
                                    Match m = r.Match(u);
                                    if (m.Success)
                                    {
                                        DataSetChattr.TableTinyUrlRow tiny = (DataSetChattr.TableTinyUrlRow)dataSetChattr.TableTinyUrl.Rows.Find(m.Groups[0].Value);
                                        if (tiny != null)
                                        {
                                            u = Regex.Replace(u, REGEX_TINYURL, tiny.url);
                                        }
                                    }
                                    u = Regex.Replace(u, "&", "&&");
                                    if (img != null)
                                    {
                                        item = new ToolStripMenuItem(u, img);
                                    }
                                    else
                                    {
                                        item = new ToolStripMenuItem(u);
                                    }
                                    item.Click += new EventHandler(contextMenuStripStatusesLink_Click);
                                    contextMenuStripStatuses.Items.Add(item);
                                    Console.WriteLine("URL: " + u);
                                }
                            }
                            // Location
                            string[] locations = parser.Locations;
                            if (locations != null)
                            {
                                contextMenuStripStatuses.Items.Add(new ToolStripSeparator());
                                foreach (string location in locations)
                                {
                                    Match m;
                                    if ((m = (new Regex(@"^(.*?)[\[\*_]")).Match(location)).Success)
                                    {
                                        item = new ToolStripMenuItem("L:" + m.Groups[1].Value);
                                    }
                                    else
                                    {
                                        item = new ToolStripMenuItem("L:" + location);
                                    }
                                    item.Click += new EventHandler(contextMenuStripStatusesLocation_Click);
                                    contextMenuStripStatuses.Items.Add(item);
                                    Console.WriteLine("Location: " + location);
                                }
                            }
                        }
                    }
                    catch (SystemException ex)
                    {
                        Console.WriteLine("contextMenuStripStatuses_Opening() Error\n" +
                            ex.Message + "\n" + "Source: " + ex.Source);
                    }
                    finally
                    {
                        mutex.ReleaseMutex();
                    }
                }
            }
        }

        void contextMenuStripStatusesUser_Click(object sender, EventArgs e)
        {
            if (sender.GetType() == typeof(ToolStripMenuItem))
            {
                ToolStripMenuItem item = (ToolStripMenuItem)sender;
                Console.WriteLine("contextMenuStripStatusesUser_Click: " + item.Text);
                string user = item.Text;
                Match m;
                if ((m = (new Regex(@"^(.*?) / ")).Match(user)).Success)
                {
                    user = m.Groups[1].Value;
                }
                Navigate("http://twitter.com/" + user + "/");
            }
        }

        void contextMenuStripStatusesLink_Click(object sender, EventArgs e)
        {
            if (sender.GetType() == typeof(ToolStripMenuItem))
            {
                ToolStripMenuItem item = (ToolStripMenuItem)sender;
                Console.WriteLine("contextMenuStripStatusesLink_Click: " + item.Text);
                Regex r = new Regex(@"^http");
                Match m = r.Match(item.Text);
                if (m.Success)
                {
                    string url = item.Text;
                    r = new Regex(@"^(.*://)(tinyurl\.com.*)$");
                    m = r.Match(item.Text);
                    if (m.Success)
                    {
                        url = m.Groups[1].Value + "preview." + m.Groups[2].Value;
                    }
                    Navigate(url);
                }
            }
        }

        void contextMenuStripStatusesLocation_Click(object sender, EventArgs e)
        {
            if (sender.GetType() == typeof(ToolStripMenuItem))
            {
                ToolStripMenuItem item = (ToolStripMenuItem)sender;
                Console.WriteLine("contextMenuStripStatusesLocation_Click: " + item.Text);
                string location = item.Text;
                Match m;
                if ((m = new Regex(@"^L:(.*)$").Match(location)).Success)
                {
                    location = m.Groups[1].Value;
                }
                Navigate("http://maps.google.co.jp/maps?oe=UTF-8&hl=ja&tab=wl&q=" + System.Uri.EscapeDataString(location) + "&ie=UTF8&z=14");
            }
        }

        private void toolStripMenuItemStatusesReply_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            EntryReply(listBox, e, table, mutex);
        }

        private void toolStripMenuItemStatusesDirect_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            EntryDirectMessage(listBox, e, table, mutex);
        }

        private void toolStripMenuItemStatusesFavorite_Click(object sender, EventArgs e)
        {
            ListBox listBox = listBoxStatuses;
            DataSetChattr.TableStatusDataTable table = dataSetChattr.TableStatus;
            Mutex mutex = m_MutexStatus;
            if (m_TblSearch != null)
            {
                listBox = listBoxStatuses;
                table = m_TblSearch;
                mutex = m_MutexSearch;
            }
            Favorite(listBox, e, table, mutex);
        }

        private void backgroundWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = (BackgroundWorker)sender;
            if (e.Argument.GetType() == typeof(String))
            {
                e.Result = DoBackGround_String((String)e.Argument, worker);
            }
            else if (e.Argument.GetType() == typeof(agsXMPP.protocol.client.Message))
            {
                e.Result = DoBackGround_XmppMessage((agsXMPP.protocol.client.Message)e.Argument, worker);
            }
            if ((e.Result == null) && worker.CancellationPending)
            {
                e.Cancel = true;
            }
        }

        private void backgroundWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            try
            {
                if (e.UserState.GetType() == typeof(String))
                {
                    switch ((ProgressOpStr)e.ProgressPercentage)
                    {
                        case ProgressOpStr.STATUS_BAR:
                            toolStripProgressBar.Visible = false;
                            toolStripStatusLabel.Text = (String)e.UserState;
                            toolStripStatusLabel.Visible = true;
                            break;
                        case ProgressOpStr.LABEL_STATUS:
                            toolStripLabelStatuses.Text = (String)e.UserState;
                            break;
                    }
                }
                else if (e.UserState.GetType() == typeof(ProgressOp))
                {
                    switch ((ProgressOp)e.UserState)
                    {
                        case ProgressOp.PROGRESS_BAR:
                            toolStripStatusLabel.Visible = false;
                            toolStripProgressBar.Value = e.ProgressPercentage;
                            toolStripProgressBar.Visible = true;
                            break;
                        case ProgressOp.NUM_STATUS:
                            toolStripLabelStatuses.Text = NumStatus();
                            break;
                        case ProgressOp.LIST_BEGIN_UPDATE:
                            listBoxStatuses.BeginUpdate();
                            break;
                        case ProgressOp.LIST_END_UPDATE:
                            listBoxStatuses.EndUpdate();
                            break;
                        case ProgressOp.LIST_ADD:
                            listBoxStatuses.Items.Add(0);
                            break;
                        case ProgressOp.LIST_INSERT:
                            listBoxStatuses.Items.Insert(e.ProgressPercentage, 0);
                            break;
                        case ProgressOp.LIST_REPLACE:
                            listBoxStatuses.Items[e.ProgressPercentage] = (int)listBoxStatuses.Items[e.ProgressPercentage] + 1;
                            break;
                        case ProgressOp.LIST_DELETE:
                            listBoxStatuses.Items[e.ProgressPercentage] = -1;
                            break;
                        case ProgressOp.LIST_REMOVE:
                            listBoxStatuses.Items.RemoveAt(e.ProgressPercentage);
                            break;
                        case ProgressOp.LIST_REMOVES:
                            for (int i = 0; i < e.ProgressPercentage; i++)
                            {
                                for (int idx = 0; idx < listBoxStatuses.Items.Count; idx++)
                                {
                                    if ((int)listBoxStatuses.Items[idx] == -1)
                                    {
                                        listBoxStatuses.Items.RemoveAt(idx);
                                        break;
                                    }
                                }
                            }
                            break;
                        case ProgressOp.LIST_SELECT:
                            listBoxStatuses.SelectedIndex = e.ProgressPercentage;
                            break;
                        case ProgressOp.LIST_SEARCH_BEGIN_UPDATE:
                            listBoxSearch.BeginUpdate();
                            break;
                        case ProgressOp.LIST_SEARCH_END_UPDATE:
                            listBoxSearch.EndUpdate();
                            break;
                        case ProgressOp.LIST_SEARCH_ADD:
                            listBoxSearch.Items.Add(0);
                            break;
                        case ProgressOp.LIST_SEARCH_INSERT:
                            listBoxSearch.Items.Insert(e.ProgressPercentage, 0);
                            break;
                        case ProgressOp.LIST_SEARCH_REPLACE:
                            listBoxSearch.Items[e.ProgressPercentage] = (int)listBoxSearch.Items[e.ProgressPercentage] + 1;
                            break;
                        case ProgressOp.LIST_SEARCH_DELETE:
                            listBoxSearch.Items[e.ProgressPercentage] = -1;
                            break;
                        case ProgressOp.LIST_SEARCH_REMOVE:
                            listBoxSearch.Items.RemoveAt(e.ProgressPercentage);
                            break;
                        case ProgressOp.LIST_SEARCH_SELECT:
                            listBoxSearch.SelectedIndex = e.ProgressPercentage;
                            break;
                    }
                }
                else if (e.UserState.GetType() == typeof(bool))
                {
                    m_fBgFlag = (e.ProgressPercentage != 0);
                }
            }
            catch (SystemException ex)
            {
                Console.WriteLine("backgroundWorker_ProgressChanged() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
        }

        private void backgroundWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Cancelled)
            {
                Quit();
                try
                {
                    Application.Exit();
                }
                catch (SystemException ex)
                {
                    Console.WriteLine("Application.Exit() Error\n" +
                        ex.Message + "\n" + "Source: " + ex.Source);
                }
            }
            else
            {
                if (e.Result != null)
                {
                    if (e.Result.GetType() == typeof(IResultXmppMessage))
                    {
                        IResultXmppMessage result = e.Result as IResultXmppMessage;
                        NotifyFlash(result.Flags);
                    }
                    else if (e.Result.GetType() == typeof(IResultGetReplies))
                    {
                        IResultGetReplies result = e.Result as IResultGetReplies;
                        StartRepliesTimer(DateTime.Now);
                        NotifyFlash(result.Flags);
                    }
                    else if (e.Result.GetType() == typeof(IResultGetFriends))
                    {
                        IResultGetFriends result = e.Result as IResultGetFriends;
                        StartFriendsTimer(DateTime.Now);
                        NotifyFlash(result.Flags);
                    }
                    else if (e.Result.GetType() == typeof(IResultUpdate))
                    {
                        IResultUpdate result = e.Result as IResultUpdate;
                        if (result.Success)
                        {
                            textBoxStatus.Text = "";
                        }
                        textBoxStatus.Enabled = true;
                        textBoxStatus.Focus();
                    }
                    else if (e.Result.GetType() == typeof(IResultInit))
                    {
                        OpenXmpp();
                        if (Properties.Settings.Default.RetrieveStartup)
                        {
                            GetFriendsTimeline();
                            GetReplies();
                        }
                        else
                        {
                            StartTimer();
                        }
                        toolStripButtonRefresh.Enabled = true;
                        toolStripButtonOffline.Enabled = true;
                        toolStripTextBoxSearch.Enabled = true;
                        toolStripSplitButtonSearch.Enabled = true;
                        textBoxStatus.Enabled = true;
                        comboBoxLocation.Enabled = true;
                    }
                }
                if (m_Loading < m_Load)
                {
                    if (!ExistRequest("load"))
                    {
                        RequestBackGround("load");
                    }
                }
                if (ArrayList.Synchronized(m_BgWork).Count != 0)
                {
                    ArrayList.Synchronized(m_BgWork).RemoveAt(0);
                }
                if (ArrayList.Synchronized(m_BgWork).Count != 0)
                {
                    backgroundWorker.RunWorkerAsync(ArrayList.Synchronized(m_BgWork)[0]);
                }
                else
                {
                    m_fBgBusy = false;
                }
            }
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            if (!toolStripButtonOffline.Checked)
            {
                DateTime now = DateTime.Now;
                TimeSpan span = now - m_TimeFriends - m_SpanOfflineFriends;
                if (m_fEnableFriends &&
                    (Properties.Settings.Default.IntervalFriends > 0) &&
                    (span.Minutes >= Properties.Settings.Default.IntervalFriends))
                {
                    m_SpanOfflineFriends = TimeSpan.Zero;
                    GetFriendsTimeline();
                }
                else if (m_fEnableFriends)
                {
                    span = (m_TimeFriends + new TimeSpan(Properties.Settings.Default.IntervalFriends * 10000000 * 60)) - now + m_SpanOfflineFriends;
                    if ((span.Minutes > 0) && (span.Seconds == 0) && (span.Minutes != m_SpanFriends.Minutes))
                    {
                        m_SpanFriends = span;
                        toolStripStatusLabel.Text = "Following ^CC擾܂ŁA " + span.Minutes + " ";
                    }
                    else if ((span.Minutes == 0) && (span.Seconds != m_SpanFriends.Seconds))
                    {
                        m_SpanFriends = span;
                        if ((span.Seconds == 29) ||
                            (span.Seconds == 19) ||
                            (span.Seconds == 14) ||
                            (span.Seconds < 10))
                            toolStripStatusLabel.Text = "Following ^CC擾܂ŁA  " + (span.Seconds + 1) + " b";
                    }
                }
                span = now - m_TimeReplies - m_SpanOfflineReplies;
                if (m_fEnableReplies &&
                    (Properties.Settings.Default.IntervalReplies > 0) &&
                    (span.Minutes >= Properties.Settings.Default.IntervalReplies))
                {
                    m_SpanOfflineReplies = TimeSpan.Zero;
                    GetReplies();
                }
            }
        }

        private void toolStripTextBoxSearch_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                toolStripSplitButtonSearch.PerformButtonClick();
            }
        }

        private void toolStripSplitButtonSearch_ButtonClick(object sender, EventArgs e)
        {
            m_MutexSearch.WaitOne();
            try
            {
                if (toolStripTextBoxSearch.Text == "")
                {
                    if (m_TblSearch != null)
                    {
                        m_TblSearch = null;
                    }
                }
                else
                {
                    m_Search = "%" + toolStripTextBoxSearch.Text + "%";
                    if (toolStripMenuItemLocation.Checked)
                    {
                        m_Search = "%L:" + toolStripTextBoxSearch.Text + "%";
                    }
                    m_TblSearch = SearchStatus(m_Search);
                    if (m_TblSearch != null)
                    {
                        int cnt = m_TblSearch.Rows.Count;
                        if (cnt == 0)
                        {
                            m_TblSearch = null;
                        }
                        else
                        {
                            listBoxSearch.BeginUpdate();
                            listBoxSearch.Items.Clear();
                            for (int i = 0; i < cnt; i++)
                            {
                                listBoxSearch.Items.Add(0);
                            }
                            listBoxSearch.SelectedIndex = 0;
                            listBoxSearch.EndUpdate();
                        }
                    }
                }
                if (m_TblSearch != null)
                {
                    listBoxStatuses.TabStop = false;
                    listBoxStatuses.Visible = false;
                    listBoxSearch.TabStop = true;
                    listBoxSearch.Visible = true;
                }
                else
                {
                    listBoxSearch.TabStop = false;
                    listBoxSearch.Visible = false;
                    listBoxStatuses.TabStop = true;
                    listBoxStatuses.Visible = true;
                }
                toolStripLabelStatuses.Text = NumStatus();
            }
            catch (SystemException ex)
            {
                Console.WriteLine("toolStripSplitButtonSearch_ButtonClick() Error\n" +
                    ex.Message + "\n" + "Source: " + ex.Source);
            }
            finally
            {
                m_MutexSearch.ReleaseMutex();
            }
        }

        private void toolStripMenuItemAll_Click(object sender, EventArgs e)
        {
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemAll.Checked = true;
            toolStripMenuItemAll.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemUser_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemUser.Checked = true;
            toolStripMenuItemUser.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemStatus_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemStatus.Checked = true;
            toolStripMenuItemStatus.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemLocation_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemSource.Checked = false;
            toolStripMenuItemLocation.Checked = true;
            toolStripMenuItemLocation.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemSource_Click(object sender, EventArgs e)
        {
            toolStripMenuItemAll.Checked = false;
            toolStripMenuItemUser.Checked = false;
            toolStripMenuItemStatus.Checked = false;
            toolStripMenuItemLocation.Checked = false;
            toolStripMenuItemSource.Checked = true;
            toolStripMenuItemSource.CheckState = CheckState.Indeterminate;
        }

        private void toolStripMenuItemLocationAdd_Click(object sender, EventArgs e)
        {
            if ((comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText)) && (comboBoxLocation.Text != ""))
            {
                bool add = true;
                foreach (string location in comboBoxLocation.Items)
                {
                    if (location == comboBoxLocation.Text)
                    {
                        add = false;
                        break;
                    }
                }
                if (add)
                {
                    comboBoxLocation.Items.Add(comboBoxLocation.Text);
                }
            }
        }

        private void toolStripMenuItemLocationDelete_Click(object sender, EventArgs e)
        {
            if (comboBoxLocation.ForeColor != Color.FromKnownColor(KnownColor.GrayText))
            {
                foreach (string location in comboBoxLocation.Items)
                {
                    if (location == comboBoxLocation.Text)
                    {
                        comboBoxLocation.Items.Remove(comboBoxLocation.Text);
                        break;
                    }
                }
            }
        }
    }
}