// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: FormBrowser.cs 3 2007-09-26 13:31:53Z ichi $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Chattr
{
    public partial class FormBrowser : Form
    {
        private FormMain m_FormMain;

        private double m_DeltaWidth;
        private double m_CurrWidth;

        public FormBrowser(FormMain main)
        {
            m_FormMain = main;
            InitializeComponent();
            webBrowser.StatusTextChanged += new EventHandler(webBrowser_StatusTextChanged);
        }

        public void Navigate(string url, bool animation)
        {
            toolStripStatusLabel.Text = "";
            if (!webBrowser.Created)
            {
                webBrowser.CreateControl();
            }
            webBrowser.Navigate(url);
            if (!this.Visible)
            {
                ShowWindow(animation);
                this.Show();
            }
            else if (this.WindowState == FormWindowState.Minimized)
            {
                this.WindowState = FormWindowState.Normal;
            }
        }

        private void ShowWindow(bool animation)
        {
            Point location = m_FormMain.Location;
            location.X += Properties.Settings.Default.FormBrowserLocation.X;
            location.Y += Properties.Settings.Default.FormBrowserLocation.Y;
            this.Location = location;
            this.Size = Properties.Settings.Default.FormBrowserSize;
            if (animation)
            {
                this.Width = 0;
                m_DeltaWidth = Properties.Settings.Default.FormBrowserSize.Width / 5.0;
                m_CurrWidth = 0;
                timer.Interval = 33;
                timer.Enabled = true;
            }
            else
            {
                this.Width = Properties.Settings.Default.FormBrowserSize.Width;
            }
        }

        private void FormBrowser_Load(object sender, EventArgs e)
        {
            this.Text = "Chattr";
            toolStripProgressBar.ProgressBar.Style = ProgressBarStyle.Continuous;
            toolStripStatusLabel.Text = "";

            //ShowWindow();
        }

        private void FormBrowser_Resize(object sender, EventArgs e)
        {
        }

        private void FormBrowser_FormClosing(object sender, FormClosingEventArgs e)
        {
            webBrowser.Stop();
            webBrowser.Navigate("about:blank");
            if (this.WindowState == FormWindowState.Normal)
            {
                Point location = this.Location;
                location.X -= m_FormMain.Location.X;
                location.Y -= m_FormMain.Location.Y;
                Properties.Settings.Default.FormBrowserLocation = location;
                Properties.Settings.Default.FormBrowserSize = this.Size;
            }
            this.Hide();
            e.Cancel = true;
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            m_CurrWidth += m_DeltaWidth;
            if (m_CurrWidth >= Properties.Settings.Default.FormBrowserSize.Width)
            {
                m_CurrWidth = Properties.Settings.Default.FormBrowserSize.Width;
                timer.Enabled = false;
            }
            this.Width = Convert.ToInt32(m_CurrWidth);
        }

        private void webBrowser_Navigating(object sender, WebBrowserNavigatingEventArgs e)
        {
            toolStripProgressBar.Visible = true;
            toolStripButtonBack.Enabled = webBrowser.CanGoBack;
            toolStripButtonForward.Enabled = webBrowser.CanGoForward;
        }

        private void webBrowser_ProgressChanged(object sender, WebBrowserProgressChangedEventArgs e)
        {
            this.Text = webBrowser.DocumentTitle;
            toolStripProgressBar.ProgressBar.Maximum = 100;
            toolStripProgressBar.ProgressBar.Value = (int)(e.CurrentProgress * 100 / e.MaximumProgress);
        }
        void webBrowser_StatusTextChanged(object sender, EventArgs e)
        {
            toolStripStatusLabel.Text = webBrowser.StatusText;
        }

        private void webBrowser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            this.Text = webBrowser.DocumentTitle;
            toolStripProgressBar.Visible = false;
            toolStripButtonBack.Enabled = webBrowser.CanGoBack;
            toolStripButtonForward.Enabled = webBrowser.CanGoForward;
        }

        private void webBrowser_NewWindow(object sender, CancelEventArgs e)
        {
            //e.Cancel = true;
        }

        private void toolStripButtonBack_Click(object sender, EventArgs e)
        {
            webBrowser.GoBack();
        }

        private void toolStripButtonForward_Click(object sender, EventArgs e)
        {
            webBrowser.GoForward();
        }

        private void toolStripButtonRefresh_Click(object sender, EventArgs e)
        {
            webBrowser.Refresh();
        }

        private void toolStripButtonStop_Click(object sender, EventArgs e)
        {
            webBrowser.Stop();
        }
    }
}