/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import java.util.Collection;

public class CollectionResponse<T> {
    private final Collection<T> items;
    private final String nextPageToken;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    protected CollectionResponse(Collection<T> items, String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public static class Builder<T> {
        private Collection<T> items;
        private String nextPageToken;

        public Builder<T> setItems(Collection<T> items) {
            this.items = items;
            return this;
        }

        public Builder<T> setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public CollectionResponse<T> build() {
            return new CollectionResponse<T>(this.items, this.nextPageToken);
        }
    }
}

