/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import java.io.InputStream;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class DosXmlReader
extends AbstractConfigXmlReader<DosXml> {
    private static final String FILENAME = "WEB-INF/dos.xml";
    private static final String BLACKLISTENTRIES_TAG = "blacklistentries";
    private static final String BLACKLIST_TAG = "blacklist";
    private static final String DESCRIPTION_TAG = "description";
    private static final String SUBNET_TAG = "subnet";

    public DosXmlReader(String appDir) {
        super(appDir, false);
    }

    public DosXml readDosXml() {
        return (DosXml)this.readConfigXml();
    }

    @Override
    protected DosXml processXml(InputStream is) {
        final DosXml dosXml = new DosXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            boolean first = true;
            DosXml.BlacklistEntry blacklistEntry;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                switch (ancestors.size()) {
                    case 0: {
                        if (!DosXmlReader.BLACKLISTENTRIES_TAG.equalsIgnoreCase(node.getTag())) {
                            throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " does not contain <" + DosXmlReader.BLACKLISTENTRIES_TAG + ">");
                        }
                        if (!this.first) {
                            throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " contains multiple <" + DosXmlReader.BLACKLISTENTRIES_TAG + ">");
                        }
                        this.first = false;
                        break;
                    }
                    case 1: {
                        if (DosXmlReader.BLACKLIST_TAG.equalsIgnoreCase(node.getTag())) {
                            this.blacklistEntry = dosXml.addNewBlacklistEntry();
                            break;
                        }
                        throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " contains <" + node.getTag() + "> instead of <" + DosXmlReader.BLACKLIST_TAG + "/>");
                    }
                    case 2: {
                        assert (this.blacklistEntry != null);
                        if (DosXmlReader.DESCRIPTION_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.blacklistEntry.setDescription((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " has bad contents in <" + DosXmlReader.DESCRIPTION_TAG + ">");
                        }
                        if (DosXmlReader.SUBNET_TAG.equalsIgnoreCase(node.getTag())) {
                            if (node.size() == 1 && node.get(0) instanceof String) {
                                this.blacklistEntry.setSubnet((String)node.get(0));
                                break;
                            }
                            throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " has bad contents in <" + DosXmlReader.SUBNET_TAG + ">");
                        }
                        throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " contains unknown <" + node.getTag() + "> inside <" + DosXmlReader.BLACKLIST_TAG + "/>");
                    }
                    default: {
                        throw new AppEngineConfigException(DosXmlReader.this.getFilename() + " has a syntax error; node <" + node.getTag() + "> is too deeply nested to be valid.");
                    }
                }
            }
        }, is);
        dosXml.validateLastEntry();
        return dosXml;
    }

    @Override
    protected String getRelativeFilename() {
        return FILENAME;
    }
}

