/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class FloatArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private float[] list;
    private int length;

    @Deprecated
    public FloatArray() {
        this.list = new float[4];
        this.length = 0;
    }

    @Deprecated
    public FloatArray(int capacity) {
        this.list = new float[capacity];
        this.length = 0;
    }

    public FloatArray(float[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new float[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private FloatArray(float[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static FloatArray newInstance(float ... array) {
        Preconditions.checkNotNull(array);
        return new FloatArray(array, array.length);
    }

    public int size() {
        return this.length;
    }

    public float get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void add(float x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void add(float[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(FloatArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            float[] copy = new float[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public float[] rep() {
        return this.list;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public float[] toArray() {
        float[] copy = new float[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public float[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        float[] copy = new float[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }
}

