/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.http.impl.nio;

import com.google.appengine.repackaged.org.apache.http.HttpRequestFactory;
import com.google.appengine.repackaged.org.apache.http.impl.DefaultHttpRequestFactory;
import com.google.appengine.repackaged.org.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpServerIOTarget;
import com.google.appengine.repackaged.org.apache.http.nio.NHttpServiceHandler;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOEventDispatch;
import com.google.appengine.repackaged.org.apache.http.nio.reactor.IOSession;
import com.google.appengine.repackaged.org.apache.http.nio.util.ByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.google.appengine.repackaged.org.apache.http.params.HttpParams;

public class DefaultServerIOEventDispatch
implements IOEventDispatch {
    protected final ByteBufferAllocator allocator;
    protected final NHttpServiceHandler handler;
    protected final HttpParams params;

    public DefaultServerIOEventDispatch(NHttpServiceHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.allocator = this.createByteBufferAllocator();
        this.handler = handler;
        this.params = params;
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return new HeapByteBufferAllocator();
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return new DefaultHttpRequestFactory();
    }

    protected NHttpServerIOTarget createConnection(IOSession session) {
        return new DefaultNHttpServerConnection(session, this.createHttpRequestFactory(), this.allocator, this.params);
    }

    public void connected(IOSession session) {
        NHttpServerIOTarget conn = this.createConnection(session);
        session.setAttribute("http.connection", conn);
        this.handler.connected(conn);
    }

    public void disconnected(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    private void ensureNotNull(NHttpServerIOTarget conn) {
        if (conn == null) {
            throw new IllegalStateException("HTTP connection is null");
        }
    }

    public void inputReady(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        conn.consumeInput(this.handler);
    }

    public void outputReady(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        conn.produceOutput(this.handler);
    }

    public void timeout(IOSession session) {
        NHttpServerIOTarget conn = (NHttpServerIOTarget)session.getAttribute("http.connection");
        this.ensureNotNull(conn);
        this.handler.timeout(conn);
    }
}

