/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.apphosting.api.ApiProxy;

public class SocketPermissions {
    private static final String SOCKET_PERMISSIONS = "com.google.appengine.api.sockets.dev.SocketPermissions.PERMISSIONS";
    private static volatile SocketPermissions defaultPermission = new SocketPermissions(false, false, false, false);
    private boolean canBind;
    private boolean canListen;
    private boolean canConnect;
    private boolean canSetSocketOpt;

    public SocketPermissions(boolean canBind, boolean canListen, boolean canConnect, boolean canSetSocketOpt) {
        this.canBind = canBind;
        this.canListen = canListen;
        this.canConnect = canConnect;
        this.canSetSocketOpt = canSetSocketOpt;
    }

    public void checkBind() {
        if (!this.canBind) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "bind");
        }
    }

    public void checkListen() {
        if (!this.canListen) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "listen");
        }
    }

    public void checkConnect() {
        if (!this.canConnect) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "connect");
        }
    }

    public void checkSetSocketOpt() {
        if (!this.canSetSocketOpt) {
            throw this.newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode.PERMISSION_DENIED, "setSocketOpt");
        }
    }

    private ApiProxy.ApplicationException newAppException(SocketServicePb.RemoteSocketServiceError.ErrorCode code, String function) {
        return new ApiProxy.ApplicationException(code.getValue(), "Not allowed to issue a socket " + function + ": permission denied.");
    }

    public static void setDefaultSocketPermissions(String canBind, String canListen, String canConnect, String canSetSocketOpt) {
        boolean lCanBin = canBind == null ? SocketPermissions.defaultPermission.canBind : Boolean.valueOf(canBind);
        boolean lCanListen = canListen == null ? SocketPermissions.defaultPermission.canListen : Boolean.valueOf(canListen);
        boolean lCanConnect = canConnect == null ? SocketPermissions.defaultPermission.canConnect : Boolean.valueOf(canConnect);
        boolean lCanSetSocketOpt = canSetSocketOpt == null ? SocketPermissions.defaultPermission.canSetSocketOpt : Boolean.valueOf(canSetSocketOpt);
        defaultPermission = new SocketPermissions(lCanBin, lCanListen, lCanConnect, lCanSetSocketOpt);
    }

    public static void setSocketPermissions(boolean canBind, boolean canListen, boolean canConnect, boolean canSetSocketOpt) {
        ApiProxy.getCurrentEnvironment().getAttributes().put(SOCKET_PERMISSIONS, new SocketPermissions(canBind, canListen, canConnect, canSetSocketOpt));
    }

    public static SocketPermissions getSocketPermissions() {
        SocketPermissions currentPermission = (SocketPermissions)ApiProxy.getCurrentEnvironment().getAttributes().get(SOCKET_PERMISSIONS);
        if (currentPermission == null) {
            return defaultPermission;
        }
        return currentPermission;
    }
}

