/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LetterTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

class WordSeparatorAnalyzer
extends Analyzer {
    static final ImmutableSet<Character> WORD_SEPARATORS = ImmutableSet.of((Object)Character.valueOf('!'), (Object)Character.valueOf('\"'), (Object)Character.valueOf('%'), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object)Character.valueOf('*'), (Object[])new Character[]{Character.valueOf(','), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('['), Character.valueOf('\\'), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\f'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf(';'), Character.valueOf('_')});

    WordSeparatorAnalyzer() {
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        WordSeparatorTokenizer tokenStream = new WordSeparatorTokenizer(reader);
        return new StandardFilter(tokenStream);
    }

    public static List<String> tokenList(String tokenizeString) {
        WordSeparatorAnalyzer analyzer = new WordSeparatorAnalyzer();
        TokenStream stream = analyzer.tokenStream("", new StringReader(tokenizeString));
        TermAttribute tokenTerm = (TermAttribute)stream.addAttribute(TermAttribute.class);
        ArrayList<String> tokens = new ArrayList<String>();
        try {
            while (stream.incrementToken()) {
                String term = tokenTerm.term();
                tokens.add(term);
            }
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
        return tokens;
    }

    public static String normalize(String tokenizeString) {
        StringBuilder builder = new StringBuilder();
        List<String> tokens = WordSeparatorAnalyzer.tokenList(tokenizeString);
        for (int i = 0; i < tokens.size(); ++i) {
            builder.append(tokens.get(i));
            if (i == tokens.size() - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String removeDiacriticals(String input) {
        String normalizedString = Normalizer.normalize(input, Normalizer.Form.NFD);
        return normalizedString.replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    private class WordSeparatorTokenizer
    extends LetterTokenizer {
        public WordSeparatorTokenizer(Reader in) {
            super(in);
        }

        @Override
        protected char normalize(char c) {
            return Character.toLowerCase(WordSeparatorAnalyzer.removeDiacriticals(Character.toString(c)).charAt(0));
        }

        @Override
        protected boolean isTokenChar(char c) {
            return !WORD_SEPARATORS.contains((Object)new Character(c));
        }
    }
}

