/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.remoteapi;

import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteApiServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(RemoteApiServlet.class.getName());
    private static final String INBOUND_APP_SYSTEM_PROPERTY = "HTTP_X_APPENGINE_INBOUND_APPID";
    private static final String INBOUND_APP_HEADER_NAME = "X-AppEngine-Inbound-AppId";
    private HashSet<String> allowedApps = null;

    boolean checkIsValidRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsKnownInbound(req) && !this.checkIsAdmin(req, res)) {
            return false;
        }
        return this.checkIsValidHeader(req, res);
    }

    private synchronized boolean checkIsKnownInbound(HttpServletRequest req) throws IOException {
        String inboundAppId;
        if (this.allowedApps == null) {
            this.allowedApps = new HashSet();
            String allowedAppsStr = System.getProperty(INBOUND_APP_SYSTEM_PROPERTY);
            if (allowedAppsStr != null) {
                String[] apps;
                for (String app : apps = allowedAppsStr.split(",")) {
                    this.allowedApps.add(app);
                }
            }
        }
        return (inboundAppId = req.getHeader(INBOUND_APP_HEADER_NAME)) != null && this.allowedApps.contains(inboundAppId);
    }

    private boolean checkIsValidHeader(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("X-appcfg-api-version") == null) {
            res.setStatus(403);
            res.setContentType("text/plain");
            res.getWriter().println("This request did not contain a necessary header");
            return false;
        }
        return true;
    }

    private boolean checkIsAdmin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserService userService = UserServiceFactory.getUserService();
        if (userService.getCurrentUser() == null) {
            res.sendRedirect(userService.createLoginURL(req.getRequestURI()));
            return false;
        }
        if (!UserServiceFactory.getUserService().isUserAdmin()) {
            res.setStatus(401);
            res.setContentType("text/plain");
            res.getWriter().println("You must be logged in as an administrator, or access from an approved application.");
            return false;
        }
        if (req.getHeader("X-appcfg-api-version") == null) {
            res.setStatus(403);
            res.setContentType("text/plain");
            res.getWriter().println("This request did not contain a necessary header");
            return false;
        }
        return true;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsValidRequest(req, res)) {
            return;
        }
        res.setContentType("text/plain");
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        StringBuilder outYaml = new StringBuilder().append("{rtok: ").append(req.getParameter("rtok")).append(", app_id: ").append(appId).append("}");
        res.getWriter().println(outYaml);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RemoteApiPb.Response response;
        block3: {
            if (!this.checkIsValidRequest(req, res)) {
                return;
            }
            res.setContentType("application/octet-stream");
            response = new RemoteApiPb.Response();
            try {
                byte[] responseData = this.executeRequest(req);
                response.setResponseAsBytes(responseData);
                res.setStatus(200);
            }
            catch (Exception e) {
                log.warning("Caught exception while executing remote_api command:\n" + e);
                res.setStatus(200);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(e);
                out.close();
                byte[] serializedException = byteStream.toByteArray();
                response.setJavaExceptionAsBytes(serializedException);
                if (!(e instanceof ApiProxy.ApplicationException)) break block3;
                ApiProxy.ApplicationException ae = (ApiProxy.ApplicationException)e;
                RemoteApiPb.ApplicationError appError = response.getMutableApplicationError();
                appError.setCode(ae.getApplicationError());
                appError.setDetail(ae.getErrorDetail());
            }
        }
        res.getOutputStream().write(response.toByteArray());
    }

    private byte[] executeRunQuery(RemoteApiPb.Request request) {
        DatastorePb.Query queryRequest = new DatastorePb.Query();
        queryRequest.parseFrom(request.getRequestAsBytes());
        int batchSize = Math.max(1000, queryRequest.getLimit());
        queryRequest.setCount(batchSize);
        DatastorePb.QueryResult runQueryResponse = new DatastorePb.QueryResult();
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", request.getRequestAsBytes());
        runQueryResponse.parseFrom(res);
        if (queryRequest.hasLimit()) {
            while (runQueryResponse.isMoreResults()) {
                DatastorePb.NextRequest nextRequest = new DatastorePb.NextRequest();
                nextRequest.getMutableCursor().mergeFrom(runQueryResponse.getCursor());
                nextRequest.setCount(batchSize);
                byte[] nextRes = ApiProxy.makeSyncCall("datastore_v3", "Next", nextRequest.toByteArray());
                runQueryResponse.mergeFrom(nextRes);
            }
        }
        return runQueryResponse.toByteArray();
    }

    private byte[] executeTxQuery(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionQueryResult result = new RemoteApiPb.TransactionQueryResult();
        DatastorePb.Query query = new DatastorePb.Query();
        query.parseFrom(request.getRequestAsBytes());
        if (!query.hasAncestor()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "No ancestor in transactional query.");
        }
        OnestoreEntity.Reference egKey = result.getMutableEntityGroupKey().mergeFrom(query.getAncestor());
        OnestoreEntity.Path.Element root = egKey.getPath().getElement(0);
        egKey.getMutablePath().clearElement().addElement(root);
        OnestoreEntity.Path.Element egElement = new OnestoreEntity.Path.Element();
        egElement.setType("__entity_group__").setId(1L);
        egKey.getMutablePath().addElement(egElement);
        byte[] tx = RemoteApiServlet.beginTransaction(false);
        query.getMutableTransaction().parseFrom(tx);
        byte[] queryBytes = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", query.toByteArray());
        result.getMutableResult().mergeFrom(queryBytes);
        DatastorePb.GetRequest egRequest = new DatastorePb.GetRequest();
        egRequest.addKey(egKey);
        DatastorePb.GetResponse egResponse = RemoteApiServlet.txGet(tx, egRequest);
        if (egResponse.getEntity(0).hasEntity()) {
            result.setEntityGroup(egResponse.getEntity(0).getEntity());
        }
        RemoteApiServlet.rollback(tx);
        return result.toByteArray();
    }

    static byte[] computeSha1(OnestoreEntity.EntityProto entity) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] entityBytes = entity.toByteArray();
        md.update(entityBytes, 0, entityBytes.length - 1);
        byte[] entityHash = md.digest();
        return entityHash;
    }

    private byte[] executeTx(RemoteApiPb.Request request) {
        RemoteApiPb.TransactionRequest txRequest = new RemoteApiPb.TransactionRequest();
        txRequest.parseFrom(request.getRequestAsBytes());
        byte[] tx = RemoteApiServlet.beginTransaction(txRequest.isAllowMultipleEg());
        List<RemoteApiPb.TransactionRequest.Precondition> preconditions = txRequest.preconditions();
        if (!preconditions.isEmpty()) {
            DatastorePb.GetRequest getRequest = new DatastorePb.GetRequest();
            for (RemoteApiPb.TransactionRequest.Precondition precondition : preconditions) {
                OnestoreEntity.Reference key = precondition.getKey();
                OnestoreEntity.Reference requestKey = getRequest.addKey();
                requestKey.mergeFrom(key);
            }
            DatastorePb.GetResponse getResponse = RemoteApiServlet.txGet(tx, getRequest);
            List<DatastorePb.GetResponse.Entity> entities = getResponse.entitys();
            assert (entities.size() == preconditions.size());
            for (int i = 0; i < entities.size(); ++i) {
                DatastorePb.GetResponse.Entity entity = entities.get(i);
                RemoteApiPb.TransactionRequest.Precondition precondition = preconditions.get(i);
                if (precondition.hasHash() != entity.hasEntity()) {
                    throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
                }
                if (!entity.hasEntity()) continue;
                try {
                    byte[] entityHash = RemoteApiServlet.computeSha1(entity.getEntity());
                    if (Arrays.equals(entityHash, precondition.getHashAsBytes())) continue;
                    throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition failed");
                }
                catch (Exception e) {
                    throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), "Transaction precondition could not be computed");
                }
            }
        }
        byte[] res = new ApiBasePb.VoidProto().toByteArray();
        if (txRequest.hasPuts()) {
            DatastorePb.PutRequest putRequest = txRequest.getPuts();
            putRequest.getMutableTransaction().parseFrom(tx);
            res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.toByteArray());
        }
        if (txRequest.hasDeletes()) {
            DatastorePb.DeleteRequest deleteRequest = txRequest.getDeletes();
            deleteRequest.getMutableTransaction().parseFrom(tx);
            ApiProxy.makeSyncCall("datastore_v3", "Delete", deleteRequest.toByteArray());
        }
        ApiProxy.makeSyncCall("datastore_v3", "Commit", tx);
        return res;
    }

    private byte[] executeGetIDs(RemoteApiPb.Request request, boolean isXG) {
        DatastorePb.PutRequest putRequest = new DatastorePb.PutRequest();
        putRequest.parseFrom(request.getRequestAsBytes());
        for (OnestoreEntity.EntityProto entity : putRequest.entitys()) {
            assert (entity.propertySize() == 0);
            assert (entity.rawPropertySize() == 0);
            assert (entity.getEntityGroup().elementSize() == 0);
            List<OnestoreEntity.Path.Element> elementList = entity.getKey().getPath().elements();
            OnestoreEntity.Path.Element lastPart = elementList.get(elementList.size() - 1);
            assert (lastPart.getId() == 0L);
            assert (!lastPart.hasName());
        }
        byte[] tx = RemoteApiServlet.beginTransaction(isXG);
        putRequest.getMutableTransaction().mergeFrom(tx);
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.toByteArray());
        RemoteApiServlet.rollback(tx);
        return res;
    }

    private byte[] executeRequest(HttpServletRequest req) throws IOException {
        RemoteApiPb.Request request = new RemoteApiPb.Request();
        request.parseFrom((InputStream)req.getInputStream());
        String service = request.getServiceName();
        String method = request.getMethod();
        log.fine("remote API call: " + service + ", " + method);
        if (service.equals("remote_datastore")) {
            if (method.equals("RunQuery")) {
                return this.executeRunQuery(request);
            }
            if (method.equals("Transaction")) {
                return this.executeTx(request);
            }
            if (method.equals("TransactionQuery")) {
                return this.executeTxQuery(request);
            }
            if (method.equals("GetIDs")) {
                return this.executeGetIDs(request, false);
            }
            if (method.equals("GetIDsXG")) {
                return this.executeGetIDs(request, true);
            }
            throw new ApiProxy.CallNotFoundException(service, method);
        }
        return ApiProxy.makeSyncCall(service, method, request.getRequestAsBytes());
    }

    private static byte[] beginTransaction(boolean allowMultipleEg) {
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        byte[] req = new DatastorePb.BeginTransactionRequest().setApp(appId).setAllowMultipleEg(allowMultipleEg).toByteArray();
        return ApiProxy.makeSyncCall("datastore_v3", "BeginTransaction", req);
    }

    private static void rollback(byte[] tx) {
        ApiProxy.makeSyncCall("datastore_v3", "Rollback", tx);
    }

    private static DatastorePb.GetResponse txGet(byte[] tx, DatastorePb.GetRequest request) {
        request.getMutableTransaction().parseFrom(tx);
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        byte[] resultBytes = ApiProxy.makeSyncCall("datastore_v3", "Get", request.toByteArray());
        response.parseFrom(resultBytes);
        return response;
    }

    public static class UnknownPythonServerException
    extends RuntimeException {
        public UnknownPythonServerException(String message) {
            super(message);
        }
    }
}

