/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.X;
import java.io.Serializable;

@GoogleInternal
public final class IntArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] list;
    private int length;

    @Deprecated
    public IntArray() {
        this.list = new int[4];
        this.length = 0;
    }

    @Deprecated
    public IntArray(int capacity) {
        this.list = new int[capacity];
        this.length = 0;
    }

    public IntArray(int[] source, int start, int num) {
        X.assertTrue(num >= 0);
        this.list = new int[num];
        this.length = num;
        System.arraycopy(source, start, this.list, 0, num);
    }

    @Deprecated
    private IntArray(int[] array, int arrayLength) {
        this.list = array;
        this.length = arrayLength;
    }

    @Deprecated
    public static IntArray newInstance(int ... array) {
        Preconditions.checkNotNull(array);
        return new IntArray(array, array.length);
    }

    public int size() {
        return this.length;
    }

    public int get(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        return this.list[i];
    }

    public void set(int i, int x) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = x;
    }

    public void add(int x) {
        if (this.length >= this.list.length) {
            this.ensureCapacity(this.length + 1);
        }
        this.list[this.length++] = x;
    }

    public void add(int[] source, int start, int num) {
        if (this.length + num > this.list.length) {
            this.ensureCapacity(this.length + num);
        }
        System.arraycopy(source, start, this.list, this.length, num);
        this.length += num;
    }

    public void addArray(IntArray other) {
        this.add(other.rep(), 0, other.size());
    }

    public void clear() {
        this.length = 0;
    }

    public void removeLast() {
        X.assertTrue(this.length > 0);
        --this.length;
    }

    public void removeFast(int i) {
        X.assertTrue(i >= 0 && i < this.length);
        this.list[i] = this.list[this.length - 1];
        this.removeLast();
    }

    public int indexOf(int element) {
        for (int i = 0; i < this.length; ++i) {
            if (this.list[i] != element) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int n) {
        if (this.list.length < n) {
            int newSize = this.list.length * 2;
            if (newSize < n) {
                newSize = n;
            }
            int[] copy = new int[newSize];
            System.arraycopy(this.list, 0, copy, 0, this.length);
            this.list = copy;
        }
    }

    public int[] rep() {
        return this.list;
    }

    public void trimToSize() {
        if (this.list.length != this.length) {
            this.list = this.toArray();
        }
    }

    public int[] toArray() {
        int[] copy = new int[this.length];
        System.arraycopy(this.list, 0, copy, 0, this.length);
        return copy;
    }

    public int[] subArray(int start, int len) {
        X.assertTrue(start >= 0);
        X.assertTrue(start + len <= this.length);
        int[] copy = new int[len];
        System.arraycopy(this.list, start, copy, 0, len);
        return copy;
    }
}

