<?php
////////////////////////////////////////////////////////
// zipファイル一覧JSONを取得するCGI
////////////////////////////////////////////////////////
require_once __DIR__ . '/common.php';
require_once __DIR__ . '/calc_trip.php';

header("Content-type: application/json; charset=utf-8");

// DataGridのページャのページサイズとページ範囲、ソートカラム、順序等の情報を取得する
$page = intval(isset($_GET['page']) ? $_GET['page'] : 1);
$pageSize = intval(isset($_GET['rows']) ? $_GET['rows'] : 10);
$sortColumn = isset($_GET['sort']) ? $_GET['sort'] : 'id';
$sortOrder = isset($_GET['order']) ? ($_GET['order'] == 'asc' ? 'asc' : 'desc') : 'asc';
$tzoffset = intval(isset($_GET['tzoffset']) ? $_GET['tzoffset'] : 0);

// パラメータの妥当性チェック
$valid_columns = [
    'id', 'fname', 'title', 'href', 'author', 'comment', 'regdate', 'fsize', 'license', 'report_cnt'
];
if (!in_array($sortColumn, $valid_columns, true)) {
    // 妥当なカラム名でなければサーバーエラーを返す
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}

$pdo = create_pdo();

// 件数取得
$countFetch = $pdo->prepare('select count(*) from ZIP_ENTRIES');
$countFetch->execute();
$totalCount = $countFetch->fetchColumn();
$countFetch = null;

// ページャの要求範囲でのデータ取得(ソートも指定)
$startPos = ($page - 1) * $pageSize;
$fetch = $pdo->prepare("select id, title, fname, fsize, href, author,
 datetime(regdate, :tzoffsetArg) regdate, license, hostaddr, downloaded, B.report_cnt from ZIP_ENTRIES
 left outer join (select zipid, count(*) report_cnt from REPORT_ENTRIES group by zipid) B
 on ZIP_ENTRIES.id = B.zipid
 where not exists (select * from REPORT_ENTRIES C where C.zipid = ZIP_ENTRIES.id and C.remote_addr = :hostaddr)
 order by ${sortColumn} ${sortOrder} limit :pageSize offset :startPos");
$fetch->execute([
    //'sortArg' => ($sortColumn . ' ' . $sortOrder), // sqlite3の不具合によりバインド変数が機能しないバージョンあり
    'tzoffsetArg' => ($tzoffset . ' minutes'),
    'pageSize' => $pageSize,
    'startPos' => $startPos,
    'hostaddr' => get_hostaddr()
]);
$rows = $fetch->fetchAll();
if ($rows === false) {
    // 読み取りに失敗した場合はサーバーエラーとする
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}

foreach ($rows as &$row) {
    // DB上のhostaddrを表示用にハッシュ化する
    $hostaddr = $row['hostaddr'];
    $row['hostaddr'] = substr(base64_encode(sha1(HOSTADDR_SALT . $hostaddr)), 0, 8);
    // DB上のAuthorを表示用にトリップ変換したものにする
    $author = $row['author'];
    $row['author'] = get_display_author_name($author);
}
unset($row);

$fetch = null;
$pdo = null;

$result = [
    'total' => $totalCount,
    'rows' => $rows
];
echo json_encode($result);
?>