<?php
////////////////////////////////////////
// ファイルのダウンロードCGI
////////////////////////////////////////
require_once __DIR__ . '/common.php';
require_once __DIR__ . '/direct_download.php';

$selected_id = isset($_GET['id']) ? $_GET['id'] : '';

$pdo = create_pdo();

// 件数取得
$fetch = $pdo->prepare('select fname, fsize, href from ZIP_ENTRIES where id = ?');
$fetch->execute([$selected_id]);
$row = $fetch->fetch();
if ($row === false) {
    header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found', true, 404);
    exit;
}
$fname = $row['fname'];
$fsize = $row['fsize'];
$href = $row['href'];
$fetch = null;

$file = ZIPDIR . $fname;
if ($href) {
    header("x-storage-location: ${href}");
    download_direct_url($href);

} else {
    header('Content-type: application/octet-stream');
    header('Content-Length: ' . filesize($file));
    $res = @readfile($file);
    if ($res === false) {
        append_log("download error: ${res}");
    }
}

$upd = $pdo->prepare('update ZIP_ENTRIES set downloaded = downloaded + 1 where id = ?');
$upd->execute([$selected_id]);
$upd = null;
?>