<?php
require_once __DIR__ . '/common.php';

/**
 * Author文字列中に#がある場合は、#以降をトリップキーとして取り出す。
 * トリップがない場合は空文字を返す。
 * @param string $author トリップキーを含む可能性のある作者名
 * @return トリップキー、もしくは空文字(トリップキーは#で始まる)
 */
function get_trip_pass($author) {
    $pos = strpos($author, '#');
    if ($pos === false) {
        return "";
    }
    $passphrase = substr($author, $pos);
    return $passphrase;
}

/**
 * Author文字列中に#がある場合は、#以降をトリップキーとして
 * 一方向ハッシュ化した文字列に変換して返す。
 * トリップがない場合は、作者名をそのまま返す。
 * @param string $author 作者名
 * @return トリップキーがあればトリップを付与した作者名、そうでなければ、そのまま
 */
function get_display_author_name($author) {
    $pos = strpos($author, '#');
    $trip = '';
    $name = $author;
    if ($pos !== false) {
        $name = substr($author, 0, $pos);
        $passphrase = substr($author, $pos); // (トリップキーは#で始まる)
        $trip = '#' . substr(calc_trip($passphrase), 0, 12); // トリップ値を先頭12文字に制限
    }
    return $name . $trip;
}

/**
 * トリップキーから表示用の一方向ハッシュに変換した文字列を取得する
 * @param string $passphrase トリップキー
 * @return トリップを返す。
 */
function calc_trip($passphrase) {
    return base64_encode(sha1(TRIPSALT . $passphrase));
}
?>
