/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.progress;

import charactermanaj.ui.progress.ProgressHandle;
import charactermanaj.ui.progress.ProgressInfoHolder;
import charactermanaj.ui.progress.Worker;
import charactermanaj.ui.progress.WorkerException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerWithProgessDialog<T>
extends JDialog {
    private static final long serialVersionUID = 1L;
    private volatile boolean exitThread;
    private volatile T result;
    private volatile Throwable occuredException;
    private Thread thread;
    private Timer timer;
    private static int interval = 200;

    public WorkerWithProgessDialog(JFrame parent, Worker<T> worker) {
        super((Frame)parent, true);
        try {
            if (worker == null) {
                throw new IllegalArgumentException();
            }
            this.initComponent(parent, worker);
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    public WorkerWithProgessDialog(JDialog parent, Worker<T> worker) {
        super((Dialog)parent, true);
        try {
            if (worker == null) {
                throw new IllegalArgumentException();
            }
            this.initComponent(parent, worker);
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    private void initComponent(Component parent, Worker<T> worker) {
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setUndecorated(true);
        Container container = this.getContentPane();
        final JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setStringPainted(false);
        container.add((Component)progressBar, "South");
        String title = "please wait for a while.";
        final JLabel lblCaption = new JLabel(title);
        container.add((Component)lblCaption, "North");
        JRootPane rootPane = this.getRootPane();
        rootPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Dimension dim = progressBar.getPreferredSize();
        dim.width = (int)((double)parent.getWidth() * 0.7);
        progressBar.setPreferredSize(dim);
        this.pack();
        this.setLocationRelativeTo(parent);
        final ProgressInfoHolder progressHandle = new ProgressInfoHolder(){

            public synchronized void flush() {
                final String caption = this.getCaption();
                final Boolean indeterminate = this.getIndeterminate();
                final Integer progressMaximum = this.getProgressMaximum();
                final Integer progressCurrent = this.getProgressCurrent();
                if (caption != null || progressMaximum != null || progressCurrent != null || indeterminate != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (caption != null) {
                                lblCaption.setText(caption);
                            }
                            if (progressMaximum != null) {
                                progressBar.setMaximum(progressMaximum);
                            }
                            if (progressCurrent != null) {
                                progressBar.setValue(progressCurrent);
                            }
                            if (indeterminate != null) {
                                progressBar.setIndeterminate(indeterminate);
                                progressBar.setStringPainted(indeterminate == false);
                            }
                        }
                    });
                }
                super.flush();
            }
        };
        this.timer = new Timer(interval, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WorkerWithProgessDialog.this.exitThread || !WorkerWithProgessDialog.this.thread.isAlive()) {
                    WorkerWithProgessDialog.this.onExitWork();
                } else {
                    progressHandle.flush();
                }
            }
        });
        this.thread = new Thread(this.createJob(worker, progressHandle));
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                WorkerWithProgessDialog.this.occuredException = e;
                WorkerWithProgessDialog.this.onExitWork();
            }
        });
    }

    public static int getInterval() {
        return interval;
    }

    public static void setInterval(int interval) {
        WorkerWithProgessDialog.interval = interval;
    }

    protected Runnable createJob(final Worker<T> worker, final ProgressHandle progressHandle) {
        return new Runnable(){

            public void run() {
                try {
                    try {
                        worker.doWork(progressHandle);
                    }
                    catch (Throwable ex) {
                        WorkerWithProgessDialog.this.occuredException = ex;
                    }
                }
                finally {
                    WorkerWithProgessDialog.this.onExitWork();
                }
            }
        };
    }

    protected void onExitWork() {
        this.exitThread = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (WorkerWithProgessDialog.this.isDisplayable() && WorkerWithProgessDialog.this.isVisible()) {
                    WorkerWithProgessDialog.this.dispose();
                }
            }
        });
    }

    public void startAndWait() throws WorkerException {
        this.result = null;
        this.occuredException = null;
        this.exitThread = false;
        this.thread.start();
        try {
            this.timer.start();
            try {
                this.setVisible(true);
            }
            finally {
                this.timer.stop();
            }
        }
        finally {
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException ex) {
                    this.thread.interrupt();
                    continue;
                }
                break;
            }
        }
        if (this.occuredException != null) {
            throw new WorkerException("worker has failed." + this.occuredException.getMessage(), this.occuredException);
        }
    }

    public T getResult() {
        return this.result;
    }
}

