/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.io.EmbeddedImageResource;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageLoaderImpl;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.ui.Wallpaper;
import charactermanaj.ui.model.WallpaperFactoryDefaultErrorHandler;
import charactermanaj.ui.model.WallpaperFactoryException;
import charactermanaj.ui.model.WallpaperInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class WallpaperFactory {
    private ImageLoaderImpl imageLoader = new ImageLoaderImpl();
    private static final WallpaperFactory inst = new WallpaperFactory();
    public final ErrorHandler defaultErrorHandler = new WallpaperFactoryDefaultErrorHandler();

    private WallpaperFactory() {
    }

    public static WallpaperFactory getInstance() {
        return inst;
    }

    public Wallpaper createWallpaper(WallpaperInfo wallpaperInfo, ErrorHandler errorHandler) throws WallpaperFactoryException {
        Wallpaper wallpaper;
        block12: {
            if (wallpaperInfo == null) {
                return new Wallpaper();
            }
            if (errorHandler == null) {
                errorHandler = this.defaultErrorHandler;
            }
            wallpaper = new Wallpaper();
            try {
                String resource;
                WallpaperInfo.WallpaperResourceType typ = wallpaperInfo.getType();
                ImageResource imageResource = null;
                if (typ == WallpaperInfo.WallpaperResourceType.FILE) {
                    File imageFile = wallpaperInfo.getFile();
                    if (!(imageFile != null && imageFile.exists() && imageFile.isFile() && imageFile.canRead())) {
                        imageFile = errorHandler.missingImageFile(wallpaperInfo, imageFile);
                    }
                    if (imageFile != null) {
                        imageResource = new FileImageResource(imageFile);
                    }
                } else if (typ == WallpaperInfo.WallpaperResourceType.PREDEFINED && (resource = wallpaperInfo.getResource()) != null && resource.trim().length() > 0) {
                    imageResource = new EmbeddedImageResource(resource);
                }
                BufferedImage wallpaperImg = null;
                if (imageResource != null) {
                    try {
                        LoadedImage wallpaperLoadedImage = this.imageLoader.load(imageResource);
                        wallpaperImg = wallpaperLoadedImage.getImage();
                    }
                    catch (IOException ex) {
                        wallpaperImg = errorHandler.imageCreationFailed(wallpaperInfo, imageResource, ex);
                    }
                }
                wallpaper.setWallpaperImage(wallpaperImg);
                wallpaper.setWallpaperAlpha(wallpaperInfo.getAlpha());
                wallpaper.setBackgroundColor(wallpaperInfo.getBackgroundColor());
            }
            catch (RuntimeException ex) {
                wallpaper = errorHandler.internalError(wallpaperInfo, wallpaper, ex);
                if (wallpaper != null) break block12;
                throw ex;
            }
        }
        return wallpaper;
    }

    public static interface ErrorHandler {
        public File missingImageFile(WallpaperInfo var1, File var2) throws WallpaperFactoryException;

        public BufferedImage imageCreationFailed(WallpaperInfo var1, ImageResource var2, Throwable var3) throws WallpaperFactoryException;

        public Wallpaper internalError(WallpaperInfo var1, Wallpaper var2, Throwable var3) throws WallpaperFactoryException;
    }
}

