/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ApplicationLogHandler;
import charactermanaj.util.ConfigurationDirUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class ApplicationLoggerConfigurator {
    private static final String LOGGING_PROPERTIES = "logging.properties";

    private ApplicationLoggerConfigurator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure() {
        Exception configurationError;
        block7: {
            LogManager logManager = LogManager.getLogManager();
            logManager.reset();
            configurationError = null;
            try {
                File appDataDir = ConfigurationDirUtilities.getUserDataDir();
                File logConfig = new File(appDataDir, LOGGING_PROPERTIES);
                if (!logConfig.exists()) {
                    ApplicationLoggerConfigurator.copyDefaultLogProperty(logConfig);
                }
                InputStream is = null;
                is = logConfig.exists() ? new FileInputStream(logConfig) : ApplicationLoggerConfigurator.class.getResourceAsStream("/logging.properties");
                if (is == null) break block7;
                try {
                    logManager.readConfiguration(is);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception ex) {
                configurationError = ex;
            }
        }
        Logger logger = Logger.getLogger(ApplicationLoggerConfigurator.class.getName());
        if (configurationError != null) {
            logger.addHandler(new ConsoleHandler());
            logger.addHandler(new ApplicationLogHandler());
            logger.log(Level.WARNING, "LogConfigurationFailed", configurationError);
        }
        logger.info("open logger.");
        logger.info("application configuration: baseDir=" + ConfigurationDirUtilities.getApplicationBaseDir() + "  appData=" + ConfigurationDirUtilities.getUserDataDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyDefaultLogProperty(File logConfig) {
        block10: {
            try {
                InputStream is = ApplicationLoggerConfigurator.class.getResourceAsStream("/logging.properties");
                if (is == null) break block10;
                try {
                    FileOutputStream fos = new FileOutputStream(logConfig);
                    try {
                        int rd;
                        byte[] buf = new byte[4096];
                        while ((rd = is.read(buf)) > 0) {
                            fos.write(buf, 0, rd);
                        }
                    }
                    finally {
                        fos.close();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

