/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UkagakaImageConverter {
    private static final Logger logger = Logger.getLogger(UkagakaImageConverter.class.getName());
    private static final UkagakaImageConverter inst = new UkagakaImageConverter();

    protected UkagakaImageConverter() {
    }

    public static UkagakaImageConverter getInstance() {
        return inst;
    }

    public BufferedImage createUkagakaPNA(BufferedImage img) {
        if (img == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (img.getType() != 2) {
            throw new IllegalArgumentException("TYPE_INT_ARGB\u5c02\u7528\u3067\u3059.");
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Raster raster = img.getData();
        BufferedImage outimg = new BufferedImage(w, h, 10);
        int[] argb = null;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                argb = raster.getPixel(x, y, argb);
                int a = argb[3];
                int o = a << 16 | a << 8 | a;
                outimg.setRGB(x, y, o);
            }
        }
        return outimg;
    }

    public Color detectTransparentColorKey(BufferedImage img) {
        int idx;
        if (img == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (img.getType() != 2) {
            throw new IllegalArgumentException("TYPE_INT_ARGB\u5c02\u7528\u3067\u3059.");
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Raster raster = img.getData();
        int colorMx = 512;
        int[] colorCounts = new int[512];
        int[] argb = new int[4];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int a = (argb = raster.getPixel(x, y, argb))[3];
                if (a == 0) continue;
                int r = argb[0] >>> 5 & 7;
                int g = argb[1] >>> 5 & 7;
                int b = argb[2] >>> 5 & 7;
                int n = idx = r << 6 | g << 3 | b;
                colorCounts[n] = colorCounts[n] + 1;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "counts=" + Arrays.toString(colorCounts));
        }
        float[] colorHues = new float[512];
        float[] hsb = new float[3];
        float[] colorWeights = new float[512];
        int[] colorMap = new int[512];
        for (int idx2 = 0; idx2 < 512; ++idx2) {
            int r = idx2 >>> 6 & 7;
            int g = idx2 >>> 3 & 7;
            int b = idx2 & 7;
            r = r << 5 | 0x1F;
            g = g << 5 | 0x1F;
            b = b << 5 | 0x1F;
            hsb = Color.RGBtoHSB(r, g, b, hsb);
            colorHues[idx2] = hsb[0];
            colorWeights[idx2] = hsb[1];
            colorMap[idx2] = r << 16 | g << 8 | b;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "weight=" + Arrays.toString(colorWeights));
        }
        float[] unusedColorScore = new float[512];
        float tolerance = 0.0625f;
        for (idx = 0; idx < 512; ++idx) {
            if (colorCounts[idx] > 0) continue;
            float hue = colorHues[idx];
            float score = 0.0f;
            for (int ref = 0; ref < 512; ++ref) {
                float refHue;
                float diff;
                if (colorCounts[ref] > 0 || (diff = (tolerance - Math.abs(hue - (refHue = colorHues[ref]))) / tolerance) < 0.0f) continue;
                score += diff;
            }
            float weight = colorWeights[idx];
            unusedColorScore[idx] = score * weight;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "scores=" + Arrays.toString(unusedColorScore));
        }
        float maxScore = 0.0f;
        int maxIdx = -1;
        for (int idx3 = 0; idx3 < 512; ++idx3) {
            float score = unusedColorScore[idx3];
            if (!(score > maxScore)) continue;
            maxScore = score;
            maxIdx = idx3;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "selectedIdx=" + maxIdx + "/score=" + maxScore);
        }
        if (maxIdx >= 0) {
            return new Color(colorMap[maxIdx]);
        }
        return null;
    }

    public BufferedImage createUkagakaPNG(BufferedImage img, Color transparentColorKey) {
        int transparencyColor;
        if (img == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (img.getType() != 2) {
            throw new IllegalArgumentException("TYPE_INT_ARGB\u5c02\u7528\u3067\u3059.");
        }
        if (transparentColorKey == null) {
            transparentColorKey = this.detectTransparentColorKey(img);
        }
        if (transparentColorKey != null) {
            transparencyColor = transparentColorKey.getRGB() & 0xFFFFFF;
        } else {
            logger.log(Level.INFO, "\u900f\u904e\u8272\u306e\u9078\u629e\u304c\u3067\u304d\u306a\u304b\u3063\u305f\u305f\u3081\u30010x010101\u3067\u4ee3\u7528\u3057\u307e\u3059.");
            transparencyColor = 65793;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Raster raster = img.getData();
        int[] argb = new int[4];
        BufferedImage outimg = new BufferedImage(w, h, 1);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c;
                int a = (argb = raster.getPixel(x, y, argb))[3];
                if (a == 0) {
                    c = transparencyColor;
                } else {
                    int r = argb[0];
                    int g = argb[1];
                    int b = argb[2];
                    c = r << 16 | g << 8 | b;
                }
                outimg.setRGB(x, y, c);
            }
            outimg.setRGB(0, 0, transparencyColor);
        }
        return outimg;
    }
}

