/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import java.sql.Timestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExportPartsSelectModel
implements Comparable<ExportPartsSelectModel> {
    private boolean checked;
    private PartsIdentifier partsIdentifier;
    private PartsSpec partsSpec;
    private Timestamp timestamp;

    public ExportPartsSelectModel(PartsIdentifier partsIdentifier, PartsSpec partsSpec, boolean selected) {
        if (partsIdentifier == null || partsSpec == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsIdentifier;
        this.partsSpec = partsSpec;
        this.checked = selected;
        long maxLastModified = partsSpec.getPartsFiles().lastModified();
        this.timestamp = maxLastModified > 0L ? new Timestamp(maxLastModified) : null;
    }

    public int hashCode() {
        return this.partsIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ExportPartsSelectModel) {
            ExportPartsSelectModel o = (ExportPartsSelectModel)obj;
            return this.partsIdentifier.equals(o.partsIdentifier);
        }
        return false;
    }

    @Override
    public int compareTo(ExportPartsSelectModel o) {
        int ret = (this.checked ? 0 : 1) - (o.checked ? 0 : 1);
        if (ret == 0) {
            ret = this.partsIdentifier.compareTo(o.partsIdentifier);
        }
        return ret;
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public PartsSpec getPartsSpec() {
        return this.partsSpec;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public PartsCategory getPartsCategory() {
        return this.partsIdentifier.getPartsCategory();
    }

    public String getPartsName() {
        return this.partsIdentifier.getLocalizedPartsName();
    }

    public Timestamp getTimestamp() {
        return this.timestamp == null ? null : (Timestamp)this.timestamp.clone();
    }

    public String getAuthor() {
        return this.partsSpec.getAuthor();
    }

    public String getVersion() {
        double version = this.partsSpec.getVersion();
        if (version <= 0.0) {
            return "";
        }
        return Double.toString(version);
    }
}

