/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.AppConfigRowModel;
import charactermanaj.ui.AppConfigTableModel;
import charactermanaj.ui.RecentCharactersDir;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.SetupLocalization;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class AppConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AppConfigDialog.class.getName());
    private AppConfigTableModel appConfigTableModel;
    private JTable appConfigTable;
    private JCheckBox chkResetDoNotAskAgain;
    private RecentCharactersDir recentCharactersDir;

    public AppConfigDialog(JFrame parent) {
        super((Frame)parent, true);
        try {
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    AppConfigDialog.this.onClose();
                }
            });
            this.initComponent();
            this.loadData();
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "appConfig construct failed.", ex);
            this.dispose();
            throw ex;
        }
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        AbstractAction actApply = new AbstractAction(strings.getProperty("btn.apply")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onUpdate();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onClose();
            }
        };
        AbstractAction actLocalization = new AbstractAction(strings.getProperty("btn.setupLocalization")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onSetupLocalization();
            }
        };
        this.chkResetDoNotAskAgain = new JCheckBox(strings.getProperty("chk.askForCharactersDir"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)this.chkResetDoNotAskAgain, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add((Component)new JButton(actLocalization), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.weightx = 0.0;
        JButton btnApply = new JButton(actApply);
        btnPanel.add((Component)btnApply, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 2;
        gbc.weightx = 0.0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        this.add((Component)btnPanel, "South");
        this.setSize(350, 400);
        this.setLocationRelativeTo(this.getParent());
        JLabel lblCaution = new JLabel(strings.getProperty("caution"), 0);
        lblCaution.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        lblCaution.setForeground(Color.red);
        contentPane.add((Component)lblCaution, "North");
        this.appConfigTableModel = new AppConfigTableModel();
        AppConfig appConfig = AppConfig.getInstance();
        final Color invalidBgColor = appConfig.getInvalidBgColor();
        this.appConfigTable = new JTable(this.appConfigTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                AppConfigRowModel rowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(row);
                if (rowModel.isRejected()) {
                    comp.setBackground(invalidBgColor);
                } else if (this.isCellSelected(row, column)) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    comp.setBackground(this.getBackground());
                }
                return comp;
            }

            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int col = this.columnAtPoint(event.getPoint());
                if (col == 0) {
                    AppConfigRowModel rowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(row);
                    return rowModel.getDisplayName();
                }
                return super.getToolTipText(event);
            }
        };
        this.appConfigTable.setAutoResizeMode(3);
        this.appConfigTable.setShowGrid(true);
        this.appConfigTable.setGridColor(AppConfig.getInstance().getGridColor());
        this.appConfigTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.appConfigTableModel.adjustColumnModel(this.appConfigTable.getColumnModel());
        JScrollPane appConfigTableSP = new JScrollPane(this.appConfigTable);
        appConfigTableSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createTitledBorder(strings.getProperty("table.caption"))));
        appConfigTableSP.setVerticalScrollBarPolicy(22);
        contentPane.add((Component)appConfigTableSP, "Center");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeAppConfigDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeAppConfigDialog");
        am.put("closeAppConfigDialog", actCancel);
        boolean enableSave = !appConfig.getPrioritySaveFileList().isEmpty();
        btnApply.setEnabled(enableSave);
    }

    private void loadData() {
        Properties original = AppConfig.getInstance().getProperties();
        this.appConfigTableModel.initModel(original);
        try {
            this.recentCharactersDir = RecentCharactersDir.load();
            if (this.recentCharactersDir != null) {
                File lastUseCharactersDir = this.recentCharactersDir.getLastUseCharacterDir();
                boolean enableLastUseCharacterDir = lastUseCharactersDir != null && lastUseCharactersDir.isDirectory();
                boolean doNotAskAgain = enableLastUseCharacterDir && this.recentCharactersDir.isDoNotAskAgain();
                this.chkResetDoNotAskAgain.setEnabled(enableLastUseCharacterDir);
                this.chkResetDoNotAskAgain.setSelected(!doNotAskAgain);
            }
        }
        catch (Exception ex) {
            this.recentCharactersDir = null;
            logger.log(Level.WARNING, "RecentCharactersDir load failed.", ex);
        }
    }

    protected void onSetupLocalization() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("setupLocalization"), strings.getProperty("confirm.setupLocalization.caption"), 2, 2) != 0) {
            return;
        }
        try {
            File baseDir = ConfigurationDirUtilities.getUserDataDir();
            SetupLocalization setup = new SetupLocalization(baseDir);
            setup.setupToLocal(EnumSet.allOf(SetupLocalization.Resources.class), true);
            File resourceDir = setup.getResourceDir();
            DesktopUtilities.open(resourceDir);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onClose() {
        Properties strings;
        if (this.appConfigTableModel.isModified() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog")).getProperty("confirm.close"), strings.getProperty("confirm.close.caption"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    protected void onUpdate() {
        if (this.appConfigTable.isEditing()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/appconfigdialog");
        Properties props = this.appConfigTableModel.getProperties();
        Set<String> rejectNames = AppConfig.checkProperties(props);
        if (!rejectNames.isEmpty()) {
            this.appConfigTableModel.setRejectNames(rejectNames);
            JOptionPane.showMessageDialog(this, strings.getProperty("error.message"), strings.getProperty("error.caption"), 0);
            return;
        }
        try {
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.update(props);
            appConfig.saveConfig();
            if (this.chkResetDoNotAskAgain.isEnabled()) {
                boolean doNotAskAgain;
                boolean bl = doNotAskAgain = !this.chkResetDoNotAskAgain.isSelected();
                if (doNotAskAgain != this.recentCharactersDir.isDoNotAskAgain()) {
                    this.recentCharactersDir.setDoNotAskAgain(doNotAskAgain);
                    this.recentCharactersDir.saveRecents();
                }
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        String message = strings.getProperty("caution");
        JOptionPane.showMessageDialog(this, message);
        this.dispose();
    }
}

