/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.colormodel.ColorModels;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableRow;

class LayersTableRow {
    private String layerId;
    private String layerName;
    private CategoriesTableRow partsCategory;
    private ColorGroupsTableRow colorGroup = ColorGroupsTableRow.NA;
    private int order;
    private String dir;
    private ColorModels colorModel = ColorModels.DEFAULT;

    public String getLayerId() {
        return this.layerId;
    }

    public void setLayerId(String layerId) {
        if (layerId == null || layerId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.layerId = layerId.trim();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        if (layerName == null || layerName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.layerName = layerName.trim();
    }

    public CategoriesTableRow getPartsCategory() {
        return this.partsCategory;
    }

    public void setPartsCategory(CategoriesTableRow partsCategory) {
        this.partsCategory = partsCategory;
    }

    public ColorGroupsTableRow getColorGroup() {
        return this.colorGroup;
    }

    public void setColorGroup(ColorGroupsTableRow colorGroup) {
        if (colorGroup == null) {
            throw new IllegalArgumentException();
        }
        this.colorGroup = colorGroup;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        if (dir == null || dir.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if ((dir = dir.trim()).indexOf("/") >= 0 || dir.indexOf("\\") >= 0 || dir.indexOf("..") >= 0 || dir.endsWith(".")) {
            throw new IllegalArgumentException("not simple name: " + dir);
        }
        this.dir = dir;
    }

    public ColorModels getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(ColorModels colorModel) {
        this.colorModel = colorModel;
    }

    public boolean isValid() {
        return this.layerName != null && this.layerName.trim().length() > 0 && this.dir != null && this.dir.trim().length() > 0 && this.partsCategory != null && this.colorGroup != null;
    }

    public Layer toLayer() {
        if (!this.isValid()) {
            return null;
        }
        ColorGroup colorGroup = this.getColorGroup().convert();
        return new Layer(this.getLayerId(), this.getLayerName(), this.getOrder(), colorGroup, colorGroup.isEnabled(), this.getDir(), this.getColorModel().name());
    }
}

