/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.PartsDataLoader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsManageDataDecorateLoader
implements PartsDataLoader {
    private PartsDataLoader parent;
    private PartsManageDataFactory partsManageDataFactory;

    public PartsManageDataDecorateLoader(PartsDataLoader parent, PartsManageDataFactory partsManageDataFactory) {
        if (parent == null || partsManageDataFactory == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.partsManageDataFactory = partsManageDataFactory;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> load(PartsCategory category) {
        Map<PartsIdentifier, PartsSpec> partsSpecs = this.parent.load(category);
        PartsManageData partsManageData = this.partsManageDataFactory.createPartsManageData();
        if (partsManageData == null || partsManageData.isEmpty()) {
            return partsSpecs;
        }
        HashMap<PartsIdentifier, PartsSpec> newPartsSpecs = new HashMap<PartsIdentifier, PartsSpec>();
        for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsSpecs.entrySet()) {
            PartsManageData.PartsVersionInfo versionInfo;
            PartsIdentifier orgPartsId = entry.getKey();
            PartsSpec partsSpec = entry.getValue();
            PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(orgPartsId);
            String localizedName = partsManageData.getLocalizedName(partsKey);
            PartsIdentifier newPartsId = localizedName != null && localizedName.length() > 0 && !localizedName.equals(orgPartsId.getLocalizedPartsName()) ? orgPartsId.setLocalizedPartsName(localizedName) : orgPartsId;
            PartsAuthorInfo partsAuthorInfo = partsManageData.getPartsAuthorInfo(partsKey);
            if (partsAuthorInfo != null) {
                partsSpec.setAuthorInfo(partsAuthorInfo);
            }
            if ((versionInfo = partsManageData.getVersion(partsKey)) != null) {
                double version = versionInfo.getVersion();
                String downloadURL = versionInfo.getDownloadURL();
                partsSpec.setVersion(version);
                partsSpec.setDownloadURL(downloadURL);
            }
            newPartsSpecs.put(newPartsId, partsSpec);
        }
        return newPartsSpecs;
    }

    public static interface PartsManageDataFactory {
        public PartsManageData createPartsManageData();
    }
}

