/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 5049488493598426918L;
    public static final OrderedMap<?, ?> EMPTY_MAP = new OrderedMap();
    private ArrayList<Map.Entry<K, V>> entries = new ArrayList();
    private transient HashMap<K, V> entryMap = new HashMap();

    public static final <K, V> OrderedMap<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.entryMap = new HashMap();
        for (Map.Entry<K, V> entry : this.entries) {
            this.entryMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    protected OrderedMap() {
    }

    public OrderedMap(Collection<V> datas, KeyDetector<K, V> keyDetector) {
        if (datas == null || keyDetector == null) {
            throw new IllegalArgumentException();
        }
        for (V data : datas) {
            K key = keyDetector.getKey(data);
            if (key == null) {
                throw new IllegalArgumentException("null key: " + data);
            }
            this.entries.add(new OrderedMapEntry<K, V>(key, data));
            this.entryMap.put(key, data);
        }
        if (this.entries.size() != this.entryMap.size()) {
            throw new IllegalArgumentException("duplicate-key");
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return OrderedMap.this.entries.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator ite = OrderedMap.this.entries.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return ite.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return (Map.Entry)ite.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public List<V> asList() {
        return new AbstractList<V>(){

            @Override
            public int size() {
                return OrderedMap.this.entries.size();
            }

            @Override
            public V get(int index) {
                return ((Map.Entry)OrderedMap.this.entries.get(index)).getValue();
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.entryMap.get(key);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class OrderedMapEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 5111249402034089224L;
        private final K key;
        private final V data;

        protected OrderedMapEntry(K key, V data) {
            this.key = key;
            this.data = data;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.data;
        }

        @Override
        public V setValue(V arg0) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyDetector<K, V> {
        public K getKey(V var1);
    }
}

