/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class TextReadHelper {
    private TextReadHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextTryEncoding(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int ch;
            while ((ch = is.read()) != -1) {
                bos.write((byte)ch);
            }
        }
        finally {
            is.close();
        }
        byte[] buf = bos.toByteArray();
        String enc = null;
        if (buf.length >= 2) {
            if ((buf[0] & 0xFF) == 255 && (buf[1] & 0xFF) == 254) {
                enc = "UTF-16LE";
            } else if ((buf[0] & 0xFF) == 254 && (buf[1] & 0xFF) == 255) {
                enc = "UTF-16BE";
            }
        }
        if (enc == null && buf.length >= 3 && (buf[0] & 0xFF) == 239 && (buf[1] & 0xFF) == 187 && (buf[1] & 0xFF) == 191) {
            enc = "UTF-8";
        }
        if (enc == null) {
            enc = "JISAutoDetect";
        }
        StringBuilder str = new StringBuilder();
        InputStreamReader rd = new InputStreamReader((InputStream)new ByteArrayInputStream(buf), enc);
        try {
            int ch;
            while ((ch = rd.read()) != -1) {
                str.append((char)ch);
            }
        }
        finally {
            rd.close();
        }
        String line = str.toString();
        line = line.replace("\r\n", "\n");
        line = line.replace("\r", "\n");
        line = line.replace("\n", System.getProperty("line.separator"));
        return line;
    }
}

