/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.clipboardSupport.ImageSelection;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.IOException;

public final class ClipboardUtil {
    private ClipboardUtil() {
    }

    public static void setImage(BufferedImage img, Color bgColor) {
        if (img == null || bgColor == null) {
            throw new IllegalArgumentException();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        ImageSelection imageSelection = new ImageSelection(img, bgColor);
        cb.setContents(imageSelection, null);
    }

    public static boolean hasImage() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        return ImageSelection.isSupprotedFlavorAvailable(cb);
    }

    public static BufferedImage getImage() throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        return ImageSelection.getImage(cb);
    }
}

