/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.clipboardSupport.ImageSelection;
import charactermanaj.graphics.io.ImageCacheMBeanImpl;
import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SelectCharatersDirDialog;
import charactermanaj.util.AWTExceptionLoggingHandler;
import charactermanaj.util.ApplicationLoggerConfigurator;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.FileNameNormalizer;
import charactermanaj.util.JavaVersionUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class Main
implements Runnable {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final boolean isMacOSX;
    private static final boolean isLinux;

    private static void initLogger() {
        try {
            ApplicationLoggerConfigurator.configure();
            if (JavaVersionUtils.getJavaVersion() >= 1.7) {
                final AWTExceptionLoggingHandler logHandler = new AWTExceptionLoggingHandler();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        final Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
                        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                            public void uncaughtException(Thread t, Throwable ex) {
                                logHandler.handle(ex);
                                if (handler != null) {
                                    handler.uncaughtException(t, ex);
                                }
                            }
                        });
                    }
                });
            } else {
                System.setProperty("sun.awt.exception.handler", AWTExceptionLoggingHandler.class.getName());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "logger initiation failed. " + ex, ex);
        }
    }

    private static void setupUIManager(AppConfig appConfig) throws Exception {
        if (Main.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
            if (JavaVersionUtils.getJavaVersion() >= 1.7) {
                FileNameNormalizer.setupNFCNormalizer();
            }
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        int fontSize = appConfig.getDefaultFontSize();
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Object val;
            Object key = entry.getKey();
            if (!key.toString().toLowerCase().endsWith("font") || !((val = UIManager.get(key)) instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)val;
            fontUIResource = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle(), fontSize);
            UIManager.put(entry.getKey(), fontUIResource);
        }
        Object textFieldFontUI = UIManager.get("TextField.font");
        if (textFieldFontUI == null) {
            textFieldFontUI = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"dialog", 0, fontSize});
        }
        UIManager.put("TextArea.font", textFieldFontUI);
    }

    public void run() {
        try {
            File defaultCharacterDir;
            File charsDir;
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            try {
                Main.setupUIManager(appConfig);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(Level.WARNING, "UIManager setup failed.", ex);
            }
            if (!ImageSelection.setupSystemFlavorMap()) {
                logger.log(Level.WARNING, "failed to set the clipboard-support.");
            }
            int[] versions = JavaVersionUtils.getJavaVersions();
            if (Main.isMacOSX() && versions[0] == 1 && versions[1] == 7 && versions[3] < 60) {
                String lang = System.getenv("LANG");
                String lcctype = System.getenv("LC_CTYPE");
                if (!(lang != null && lang.trim().length() != 0 || lcctype != null && lcctype.trim().length() != 0)) {
                    JOptionPane.showMessageDialog(null, "\"LANG\" or \"LC_CTYPE\" environment variable must be set.", "Configuration Error", 0);
                }
            }
            File currentCharacterDir = null;
            String charactersDir = System.getProperty("charactersDir");
            if (charactersDir != null && charactersDir.length() > 0 && (charsDir = new File(charactersDir)).exists() && charsDir.isDirectory()) {
                currentCharacterDir = charsDir;
            }
            if (currentCharacterDir == null && (currentCharacterDir = SelectCharatersDirDialog.getCharacterDir(defaultCharacterDir = ConfigurationDirUtilities.getDefaultCharactersDir())) == null) {
                logger.info("luncher canceled.");
                return;
            }
            DirectoryConfig.getInstance().setCharactersDir(currentCharacterDir);
            StartupSupport.getInstance().doStartup();
            MainFrame mainFrame = ProfileListManager.openDefaultProfile();
            if (Main.isMacOSX()) {
                try {
                    Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                    Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
                    mtd.invoke(null, mainFrame);
                }
                catch (Throwable ex) {
                    logger.log(Level.CONFIG, "The Apple Java Extensions is not found.", ex);
                }
            }
            mainFrame.showMainFrame();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Application initiation failed.", ex);
            ErrorMessageHelper.showErrorDialog(null, ex);
            MainFrame.closeAllProfiles();
        }
    }

    public static void main(String[] args) {
        Main.initLogger();
        try {
            ImageCacheMBeanImpl.setupMBean();
        }
        catch (JMException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        SwingUtilities.invokeLater(new Main());
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isLinuxOrMacOSX() {
        return isLinux || isMacOSX;
    }

    static {
        String lcOS = System.getProperty("os.name").toLowerCase();
        isMacOSX = lcOS.startsWith("mac os x");
        isLinux = lcOS.indexOf("linux") >= 0;
    }
}

