/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.util;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class SpinnerWheelSupportListener
implements MouseWheelListener {
    protected SpinnerModel model;

    public SpinnerWheelSupportListener(SpinnerModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotate = e.getWheelRotation();
        Object nextval = null;
        if (rotate < 0) {
            nextval = this.model.getNextValue();
        } else if (rotate > 0) {
            nextval = this.model.getPreviousValue();
        }
        if (nextval != null) {
            if (this.model instanceof SpinnerNumberModel) {
                SpinnerNumberModel nmodel = (SpinnerNumberModel)this.model;
                Comparable<?> max = nmodel.getMaximum();
                Comparable<?> min = nmodel.getMinimum();
                if (max.compareTo((Number)nextval) < 0) {
                    nextval = null;
                } else if (min.compareTo((Number)nextval) > 0) {
                    nextval = null;
                }
            }
            try {
                if (nextval != null) {
                    this.model.setValue(nextval);
                }
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }
}

