/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportPresetModel {
    private boolean cheched;
    private PartsSet partsSet;
    private boolean overwrite;
    private Collection<PartsIdentifier> missingPartsIdentifiers = Collections.emptySet();

    public ImportPresetModel(PartsSet partsSet, boolean overwrite, boolean checked) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        this.partsSet = partsSet;
        this.cheched = checked;
        this.overwrite = overwrite;
    }

    public boolean isCheched() {
        return this.cheched;
    }

    public void setCheched(boolean cheched) {
        this.cheched = cheched;
    }

    public PartsSet getPartsSet() {
        return this.partsSet;
    }

    public String getPartsSetName() {
        return this.partsSet.getLocalizedName();
    }

    public void setPartsSetName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.partsSet.setLocalizedName(name);
    }

    public Collection<PartsIdentifier> getMissingPartsIdentifiers() {
        return this.missingPartsIdentifiers;
    }

    public boolean hasMissingParts() {
        return true;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean checkMissingParts(Collection<PartsIdentifier> importedPartsIdentifiers) {
        boolean modified;
        HashSet<PartsIdentifier> missingPartsIdentifiers = new HashSet<PartsIdentifier>();
        for (List partsIdentifiers : this.partsSet.values()) {
            for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                boolean exists = false;
                if (importedPartsIdentifiers != null && importedPartsIdentifiers.contains(partsIdentifier)) {
                    exists = true;
                }
                if (exists) continue;
                missingPartsIdentifiers.add(partsIdentifier);
            }
        }
        boolean bl = modified = !missingPartsIdentifiers.equals(this.missingPartsIdentifiers);
        if (modified) {
            this.missingPartsIdentifiers = missingPartsIdentifiers;
        }
        return modified;
    }
}

