/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsIdentifier;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsManageData
extends AbstractCollection<PartsKey> {
    private HashMap<PartsKey, PartsAuthorInfo> partsAuthorInfoMap = new HashMap();
    private HashMap<PartsKey, String> partsLocalizedNameMap = new HashMap();
    private HashMap<PartsKey, PartsVersionInfo> partsVersionInfoMap = new HashMap();

    @Override
    public void clear() {
        this.partsAuthorInfoMap.clear();
        this.partsLocalizedNameMap.clear();
        this.partsVersionInfoMap.clear();
    }

    public void putPartsInfo(PartsKey partsKey, String localizedName, PartsAuthorInfo partsAuthorInfo, PartsVersionInfo versionInfo) {
        if (partsKey == null) {
            throw new IllegalArgumentException();
        }
        this.partsAuthorInfoMap.put(partsKey, partsAuthorInfo);
        this.partsLocalizedNameMap.put(partsKey, localizedName);
        this.partsVersionInfoMap.put(partsKey, versionInfo);
    }

    public PartsAuthorInfo getPartsAuthorInfo(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        PartsAuthorInfo authorInfo = this.partsAuthorInfoMap.get(partsKey);
        if (authorInfo == null) {
            for (Map.Entry<PartsKey, PartsAuthorInfo> entry : this.partsAuthorInfoMap.entrySet()) {
                PartsKey key = entry.getKey();
                if (!key.getPartsName().equals(partsKey.getPartsName())) continue;
                authorInfo = entry.getValue();
                break;
            }
        }
        return authorInfo;
    }

    public PartsAuthorInfo getPartsAuthorInfoStrict(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        return this.partsAuthorInfoMap.get(partsKey);
    }

    public PartsVersionInfo getVersion(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        PartsVersionInfo versionInfo = this.partsVersionInfoMap.get(partsKey);
        if (versionInfo == null) {
            for (Map.Entry<PartsKey, PartsVersionInfo> entry : this.partsVersionInfoMap.entrySet()) {
                PartsKey key = entry.getKey();
                if (!key.getPartsName().equals(partsKey.getPartsName())) continue;
                versionInfo = entry.getValue();
                break;
            }
        }
        return versionInfo;
    }

    public String getLocalizedName(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        String localizedName = this.partsLocalizedNameMap.get(partsKey);
        if (localizedName == null) {
            for (Map.Entry<PartsKey, String> entry : this.partsLocalizedNameMap.entrySet()) {
                PartsKey key = entry.getKey();
                if (!key.getPartsName().equals(partsKey.getPartsName())) continue;
                localizedName = entry.getValue();
                break;
            }
        }
        return localizedName;
    }

    public PartsVersionInfo getVersionStrict(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        return this.partsVersionInfoMap.get(partsKey);
    }

    public String getLocalizedNameStrict(PartsKey partsKey) {
        if (partsKey == null) {
            return null;
        }
        return this.partsLocalizedNameMap.get(partsKey);
    }

    public Collection<PartsAuthorInfo> getAuthorInfos() {
        HashMap<String, PartsAuthorInfo> authorInfos = new HashMap<String, PartsAuthorInfo>();
        for (PartsAuthorInfo authorInfo : this.partsAuthorInfoMap.values()) {
            String author;
            if (authorInfo == null || (author = authorInfo.getAuthor()) == null || author.length() <= 0) continue;
            authorInfos.put(author, authorInfo);
        }
        return authorInfos.values();
    }

    public Collection<PartsKey> getPartsKeysByAuthor(String author) {
        if (author == null) {
            return Collections.emptyList();
        }
        ArrayList<PartsKey> partsKeys = new ArrayList<PartsKey>();
        for (Map.Entry<PartsKey, PartsAuthorInfo> entry : this.partsAuthorInfoMap.entrySet()) {
            PartsKey partsKey = entry.getKey();
            PartsAuthorInfo partsAuthorInfo = entry.getValue();
            if (partsAuthorInfo == null) continue;
            String author2 = partsAuthorInfo.getAuthor();
            if (author2 == null) {
                author2 = "";
            }
            if (!author2.equals(author)) continue;
            partsKeys.add(partsKey);
        }
        return partsKeys;
    }

    @Override
    public Iterator<PartsKey> iterator() {
        return this.partsAuthorInfoMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.partsAuthorInfoMap.size();
    }

    public static final class PartsVersionInfo {
        private double version;
        private String downloadURL;
        private Timestamp lastModified;

        public PartsVersionInfo() {
        }

        public PartsVersionInfo(double version, String downloadURL) {
            this(version, downloadURL, null);
        }

        public PartsVersionInfo(double version, String downloadURL, Timestamp lastModified) {
            this.version = version;
            this.downloadURL = downloadURL;
            this.lastModified = lastModified;
        }

        public double getVersion() {
            return this.version;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public void setVersion(double version) {
            this.version = version;
        }

        public void setDownloadURL(String downloadURL) {
            this.downloadURL = downloadURL;
        }

        public Timestamp getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(Timestamp lastModified) {
            this.lastModified = lastModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartsKey
    implements Comparable<PartsKey> {
        private final String partsName;
        private final String categoryId;

        public PartsKey(String partsName) {
            this(partsName, null);
        }

        public PartsKey(String partsName, String categoryId) {
            if (partsName == null || partsName.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (categoryId != null && categoryId.trim().length() == 0) {
                categoryId = null;
            }
            this.partsName = partsName;
            this.categoryId = categoryId;
        }

        public PartsKey(PartsIdentifier partsIdentifier) {
            if (partsIdentifier == null) {
                throw new IllegalArgumentException();
            }
            this.partsName = partsIdentifier.getPartsName();
            this.categoryId = partsIdentifier.getPartsCategory().getCategoryId();
        }

        @Override
        public int compareTo(PartsKey o) {
            int ret = this.partsName.compareTo(o.partsName);
            if (ret == 0 && (this.categoryId == null || o.categoryId == null)) {
                ret = this.categoryId == o.categoryId ? 0 : (this.categoryId == null ? -1 : 1);
            }
            return ret;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public String getPartsName() {
            return this.partsName;
        }

        public int hashCode() {
            return this.partsName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof PartsKey) {
                PartsKey o = (PartsKey)obj;
                if (this.partsName.equals(o.partsName)) {
                    return this.categoryId == null ? o.categoryId == null : this.categoryId.equals(o.categoryId);
                }
            }
            return false;
        }
    }
}

