/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageResource;
import charactermanaj.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedImageResource
extends ResourceLoader
implements ImageResource,
Serializable {
    private static final long serialVersionUID = 703707046457343373L;
    private static final Logger logger = Logger.getLogger(EmbeddedImageResource.class.getName());
    private String resourceName;

    public EmbeddedImageResource(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException();
        }
        this.resourceName = resourceName;
    }

    public int compareTo(ImageResource o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    public int hashCode() {
        return this.getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ImageResource) {
            ImageResource o = (ImageResource)obj;
            return this.getFullName().equals(o.getFullName());
        }
        return false;
    }

    public String getFullName() {
        return this.resourceName;
    }

    public URI getURI() {
        URL url = this.getResource(this.resourceName);
        if (url != null) {
            try {
                return url.toURI();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.WARNING, "resource name is invalid. " + this.resourceName, ex);
            }
        }
        return null;
    }

    public long lastModified() {
        URL url = this.getResource(this.resourceName);
        if (url == null) {
            return 1L;
        }
        return 0L;
    }

    public InputStream openStream() throws IOException {
        URL url = this.getResource(this.resourceName);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public String toString() {
        return this.getFullName();
    }
}

