/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.io.PartsInfoXMLWriter;
import charactermanaj.ui.PartsManageTableModel;
import charactermanaj.ui.PartsManageTableRow;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

public class PartsManageDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/partsmanagedialog";
    private static final Logger logger = Logger.getLogger(PartsManageDialog.class.getName());
    private CharacterData characterData;
    private PartsManageTableModel partsManageTableModel;
    private JTable partsManageTable;
    private JTextField txtHomepage;
    private JTextField txtAuthor;
    private boolean updated;
    private Semaphore authorEditSemaphore = new Semaphore(1);

    public PartsManageDialog(JFrame parent, CharacterData characterData) {
        super((Frame)parent, true);
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.characterData = characterData;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PartsManageDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        JPanel partsListPanel = new JPanel();
        partsListPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("partslist"))));
        GridBagLayout partsListPanelLayout = new GridBagLayout();
        partsListPanel.setLayout(partsListPanelLayout);
        this.partsManageTableModel = new PartsManageTableModel();
        this.partsManageTable = new JTable(this.partsManageTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int rowIdx, int columnIdx) {
                PartsManageTableModel.Columns column = PartsManageTableModel.Columns.values()[columnIdx];
                Component comp = super.prepareRenderer(renderer, rowIdx, columnIdx);
                PartsManageTableRow row = (PartsManageTableRow)PartsManageDialog.this.partsManageTableModel.getRow(rowIdx);
                Timestamp current = row.getTimestamp();
                Timestamp lastModified = row.getLastModified();
                boolean warnings = false;
                if (current != null && !current.equals(lastModified)) {
                    warnings = true;
                }
                if (warnings && column == PartsManageTableModel.Columns.LastModified) {
                    AppConfig appConfig = AppConfig.getInstance();
                    Color invalidBgColor = appConfig.getInvalidBgColor();
                    comp.setBackground(invalidBgColor);
                } else if (this.isCellSelected(rowIdx, columnIdx)) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    comp.setBackground(this.getBackground());
                }
                return comp;
            }
        };
        this.partsManageTable.setShowGrid(true);
        this.partsManageTable.setGridColor(AppConfig.getInstance().getGridColor());
        this.partsManageTableModel.adjustColumnModel(this.partsManageTable.getColumnModel());
        this.partsManageTable.setAutoResizeMode(0);
        this.partsManageTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JScrollPane partsManageTableSP = new JScrollPane(this.partsManageTable);
        this.partsManageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PartsManageDialog.this.onChangeSelection();
                }
            }
        });
        this.partsManageTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                PartsManageDialog.this.onTableDataChange(e.getFirstRow(), e.getLastRow());
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 4;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        partsListPanel.add((Component)partsManageTableSP, gbc);
        AbstractAction actSortByName = new AbstractAction(strings.getProperty("sortByName")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onSortByName();
            }
        };
        AbstractAction actSortByAuthor = new AbstractAction(strings.getProperty("sortByAuthor")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onSortByAuthor();
            }
        };
        AbstractAction actSortByTimestamp = new AbstractAction(strings.getProperty("sortByTimestamp")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onSortByTimestamp();
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        partsListPanel.add((Component)new JButton(actSortByName), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        partsListPanel.add((Component)new JButton(actSortByAuthor), gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        partsListPanel.add((Component)new JButton(actSortByTimestamp), gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        partsListPanel.add(Box.createHorizontalGlue(), gbc);
        contentPane.add((Component)partsListPanel, "Center");
        JPopupMenu popupMenu = new JPopupMenu();
        AbstractAction actApplyAllLastModified = new AbstractAction(strings.getProperty("applyAllLastModified")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onApplyAllLastModified();
            }
        };
        AbstractAction actApplyAllDownloadURL = new AbstractAction(strings.getProperty("applyAllDownloadURL")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onApplyAllDownloadURL();
            }
        };
        AbstractAction actApplyAllVersion = new AbstractAction(strings.getProperty("applyAllVersion")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onApplyAllVersion();
            }
        };
        popupMenu.add(actApplyAllLastModified);
        popupMenu.add(new JSeparator());
        popupMenu.add(actApplyAllVersion);
        popupMenu.add(actApplyAllDownloadURL);
        this.partsManageTable.setComponentPopupMenu(popupMenu);
        JPanel authorPanel = new JPanel();
        authorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("author.info"))));
        GridBagLayout authorPanelLayout = new GridBagLayout();
        authorPanel.setLayout(authorPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        authorPanel.add((Component)new JLabel(strings.getProperty("author"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        this.txtAuthor = new JTextField();
        authorPanel.add((Component)this.txtAuthor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        authorPanel.add((Component)new JLabel(strings.getProperty("homepage"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.txtHomepage = new JTextField();
        authorPanel.add((Component)this.txtHomepage, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        AbstractAction actBrowseHomepage = new AbstractAction(strings.getProperty("open")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onBrosweHomepage();
            }
        };
        authorPanel.add((Component)new JButton(actBrowseHomepage), gbc);
        if (!DesktopUtilities.isSupported()) {
            actBrowseHomepage.setEnabled(false);
        }
        this.txtAuthor.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditAuthor();
            }

            public void insertUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditAuthor();
            }

            public void changedUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditAuthor();
            }
        });
        this.txtHomepage.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditHomepage();
            }

            public void insertUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditHomepage();
            }

            public void changedUpdate(DocumentEvent e) {
                PartsManageDialog.this.onEditHomepage();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        AbstractAction actClose = new AbstractAction(strings.getProperty("cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onClose();
            }
        };
        AbstractAction actOK = new AbstractAction(strings.getProperty("update")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                PartsManageDialog.this.onOK();
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)new JButton(actOK), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)new JButton(actClose), gbc);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)authorPanel, "North");
        southPanel.add((Component)btnPanel, "South");
        contentPane.add((Component)southPanel, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closePartsManageDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closePartsManageDialog");
        am.put("closePartsManageDialog", actClose);
        this.partsManageTableModel.initModel(characterData);
        this.setSize(500, 400);
        this.setLocationRelativeTo(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChangeSelection() {
        try {
            this.authorEditSemaphore.acquire();
            try {
                int[] selRows = this.partsManageTable.getSelectedRows();
                HashSet<String> authors = new HashSet<String>();
                for (int selRow : selRows) {
                    PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
                    authors.add(row.getAuthor() == null ? "" : row.getAuthor());
                }
                if (authors.size() > 1) {
                    AppConfig appConfig = AppConfig.getInstance();
                    this.txtAuthor.setBackground(appConfig.getAuthorEditConflictBgColor());
                    this.txtHomepage.setBackground(appConfig.getAuthorEditConflictBgColor());
                } else {
                    Color bgColor = UIManager.getColor("TextField.background");
                    if (bgColor == null) {
                        bgColor = Color.white;
                    }
                    this.txtAuthor.setBackground(bgColor);
                    this.txtHomepage.setBackground(bgColor);
                }
                if (authors.isEmpty()) {
                    this.txtAuthor.setEditable(false);
                    this.txtAuthor.setText("");
                    this.txtHomepage.setEditable(false);
                    this.txtHomepage.setText("");
                } else {
                    this.txtAuthor.setEditable(true);
                    this.txtHomepage.setEditable(true);
                    if (authors.size() == 1) {
                        String author = (String)authors.iterator().next();
                        String homepage = this.partsManageTableModel.getHomepage(author);
                        this.txtAuthor.setText(author);
                        this.txtHomepage.setText(homepage);
                    } else {
                        this.txtAuthor.setText("");
                        this.txtHomepage.setText("");
                    }
                }
            }
            finally {
                this.authorEditSemaphore.release();
            }
        }
        catch (InterruptedException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        catch (RuntimeException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onTableDataChange(int firstRow, int lastRow) {
        this.onChangeSelection();
    }

    protected void onApplyAllLastModified() {
        int[] selRows = this.partsManageTable.getSelectedRows();
        if (selRows.length == 0) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Arrays.sort(selRows);
        for (int selRow : selRows) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
            Timestamp dt = row.getTimestamp();
            row.setLastModified(dt);
        }
        this.partsManageTableModel.fireTableRowsUpdated(selRows[0], selRows[selRows.length - 1]);
    }

    protected void onApplyAllDownloadURL() {
        String downloadURL_new;
        int[] selRows = this.partsManageTable.getSelectedRows();
        if (selRows.length == 0) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Arrays.sort(selRows);
        HashSet<String> authors = new HashSet<String>();
        for (int selRow : selRows) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
            authors.add(row.getAuthor() == null ? "" : row.getAuthor());
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (authors.size() > 1 && JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.authorConflict"), strings.getProperty("confirm"), 2) != 0) {
            return;
        }
        PartsManageTableRow firstRow = (PartsManageTableRow)this.partsManageTableModel.getRow(selRows[0]);
        String downloadURL = firstRow.getDownloadURL();
        if (downloadURL == null) {
            downloadURL = "";
        }
        if ((downloadURL_new = JOptionPane.showInputDialog(this, strings.getProperty("input.downloadURL"), downloadURL)) == null || downloadURL.equals(downloadURL_new)) {
            return;
        }
        for (int selRow : selRows) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
            row.setDownloadURL(downloadURL_new);
            Timestamp dt = row.getTimestamp();
            row.setLastModified(dt);
        }
        this.partsManageTableModel.fireTableRowsUpdated(selRows[0], selRows[selRows.length - 1]);
    }

    protected void onApplyAllVersion() {
        double version_new;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int[] selRows = this.partsManageTable.getSelectedRows();
        if (selRows.length == 0) {
            tk.beep();
            return;
        }
        Arrays.sort(selRows);
        HashSet<String> authors = new HashSet<String>();
        for (int selRow : selRows) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
            authors.add(row.getAuthor() == null ? "" : row.getAuthor());
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (authors.size() > 1 && JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.authorConflict"), strings.getProperty("confirm"), 2) != 0) {
            return;
        }
        PartsManageTableRow firstRow = (PartsManageTableRow)this.partsManageTableModel.getRow(selRows[0]);
        double version = firstRow.getVersion();
        String strVersion = version < 0.0 ? "" : Double.toString(version);
        String strVersion_new = JOptionPane.showInputDialog(this, strings.getProperty("input.version"), strVersion);
        if (strVersion_new == null || strVersion.equals(strVersion_new)) {
            return;
        }
        try {
            version_new = Double.parseDouble(strVersion_new);
        }
        catch (Exception ex) {
            tk.beep();
            return;
        }
        for (int selRow : selRows) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
            row.setVersion(version_new);
            Timestamp dt = row.getTimestamp();
            row.setLastModified(dt);
        }
        this.partsManageTableModel.fireTableRowsUpdated(selRows[0], selRows[selRows.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEditHomepage() {
        try {
            if (!this.authorEditSemaphore.tryAcquire()) {
                return;
            }
            try {
                String author = this.txtAuthor.getText();
                String homepage = this.txtHomepage.getText();
                this.partsManageTableModel.setHomepage(author, homepage);
            }
            finally {
                this.authorEditSemaphore.release();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEditAuthor() {
        try {
            if (!this.authorEditSemaphore.tryAcquire()) {
                return;
            }
            try {
                String author = this.txtAuthor.getText();
                int[] selRows = this.partsManageTable.getSelectedRows();
                int firstRow = -1;
                int lastRow = Integer.MAX_VALUE;
                for (int selRow : selRows) {
                    PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(selRow);
                    String oldValue = row.getAuthor();
                    if (oldValue != null && oldValue.equals(author)) continue;
                    row.setAuthor(author);
                    Timestamp dt = row.getTimestamp();
                    row.setLastModified(dt);
                    firstRow = Math.max(firstRow, selRow);
                    lastRow = Math.min(lastRow, selRow);
                }
                String homepage = this.partsManageTableModel.getHomepage(author);
                if (homepage == null) {
                    homepage = "";
                }
                this.txtHomepage.setText(homepage);
                if (firstRow >= 0) {
                    this.partsManageTable.repaint();
                }
            }
            finally {
                this.authorEditSemaphore.release();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onClose() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.cancel"), strings.getProperty("confirm"), 0) != 0) {
            return;
        }
        this.updated = false;
        this.dispose();
    }

    protected void onBrosweHomepage() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        String homepage = this.txtHomepage.getText();
        if (homepage == null || homepage.trim().length() == 0) {
            tk.beep();
            return;
        }
        try {
            URI uri = new URI(homepage);
            DesktopUtilities.browse(uri);
        }
        catch (Exception ex) {
            tk.beep();
            logger.log(Level.INFO, "browse failed. : " + homepage, ex);
        }
    }

    protected void onSortByAuthor() {
        this.partsManageTableModel.sortByAuthor();
    }

    protected void onSortByName() {
        this.partsManageTableModel.sortByName();
    }

    protected void onSortByTimestamp() {
        this.partsManageTableModel.sortByTimestamp();
    }

    protected void onOK() {
        if (this.partsManageTable.isEditing()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        int mx = this.partsManageTableModel.getRowCount();
        HashMap<String, PartsAuthorInfo> authorInfoMap = new HashMap<String, PartsAuthorInfo>();
        for (int idx = 0; idx < mx; ++idx) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(idx);
            String author = row.getAuthor();
            String homepage = row.getHomepage();
            if (author == null || author.trim().length() <= 0) continue;
            PartsAuthorInfo authorInfo = (PartsAuthorInfo)authorInfoMap.get(author.trim());
            if (authorInfo == null) {
                authorInfo = new PartsAuthorInfo();
                authorInfo.setAuthor(author.trim());
                authorInfoMap.put(authorInfo.getAuthor(), authorInfo);
            }
            authorInfo.setHomePage(homepage);
        }
        PartsManageData partsManageData = new PartsManageData();
        for (int idx = 0; idx < mx; ++idx) {
            PartsManageTableRow row = (PartsManageTableRow)this.partsManageTableModel.getRow(idx);
            String author = row.getAuthor();
            PartsAuthorInfo partsAuthorInfo = null;
            if (author != null && author.trim().length() > 0) {
                partsAuthorInfo = (PartsAuthorInfo)authorInfoMap.get(author.trim());
            }
            double version = row.getVersion();
            String downloadURL = row.getDownloadURL();
            String localizedName = row.getLocalizedName();
            Timestamp lastModified = row.getLastModified();
            PartsManageData.PartsVersionInfo versionInfo = new PartsManageData.PartsVersionInfo();
            versionInfo.setVersion(version);
            versionInfo.setDownloadURL(downloadURL);
            versionInfo.setLastModified(lastModified);
            PartsIdentifier partsIdentifier = row.getPartsIdentifier();
            PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsIdentifier);
            partsManageData.putPartsInfo(partsKey, localizedName, partsAuthorInfo, versionInfo);
        }
        PartsInfoXMLWriter xmlWriter = new PartsInfoXMLWriter();
        try {
            URI docBase = this.characterData.getDocBase();
            xmlWriter.savePartsManageData(docBase, partsManageData);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        this.updated = true;
        this.dispose();
    }

    public boolean isUpdated() {
        return this.updated;
    }
}

