﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Service.Database;
using NHibernate;
using System.Collections;
using Iesi.Collections;

namespace ChaKi.Service.Search
{
    public class SentenceTagService : IServiceCommand
    {
        private Corpus m_Corpus;
        private int m_SenNo;
        private List<DocumentTag> m_Result;

        public SentenceTagService(Corpus cps, int senNo, List<DocumentTag> result)
        {
            m_Corpus = cps;
            m_SenNo = senNo;
            m_Result = result;

            // 結果を消去
            m_Result.Clear();
        }

        public void Begin()
        {
            lock (m_Corpus)
            {
                // Corpus(DB)の種類に合わせてConfigurationをセットアップする
                DBService dbs = DBService.Create(m_Corpus.DBParam);
                NHibernate.Cfg.Configuration cfg = dbs.GetConnection();
                using (ISessionFactory factory = cfg.BuildSessionFactory())
                {
                    // Sentence Listのクエリを生成する
                    string qstr = QueryBuilder.Instance.BuildSentenceQuery(m_SenNo);
                    ISession session = null;
                    IList queryResult;
                    try
                    {
                        session = factory.OpenSession();
                        IQuery query = session.CreateQuery(qstr);
                        queryResult = query.List();
                        foreach (Sentence sen in queryResult)
                        {
                            foreach (object o in sen.DocumentTags)
                            {
                                DocumentTag tag = (DocumentTag)o;
                                m_Result.Add(tag);
                            }
                        }
                    }
                    finally
                    {
                        if (session != null)
                        {
                            session.Close();
                        }
                    }
                }
            }
        }
    }
}
