﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Corpora.Annotations;

namespace ChaKi.Service.Readers
{
    /// <summary>
    /// Cabochaファイルを読みながら作成される一時オブジェクト
    /// StartPosによって一意に識別できる
    /// </summary>
    internal class CabochaBunsetsu
    {
        public Sentence Sen { get; set; }
        public int StartPos { get; set; }       // Corpus内での文字位置
        public int EndPos { get; set; }         // Corpus内での文字位置
        public int BunsetsuPos { get; set; }    // 文内での文節番号
        public int DependsTo { get; set; }      // 文内での係り先文節番号
        public string DependsAs { get; set; }
        public List<Word> Words { get; set; }
        public Segment Seg { get; set; }        // 割り当てられたSegmentオブジェクトへの参照

        public CabochaBunsetsu(Sentence sen, int startPos, int bunsetsPos, string dependsAs, int dependsTo)
        {
            this.Sen = sen;
            this.BunsetsuPos = bunsetsPos;
            this.StartPos = startPos;
            this.EndPos = startPos;
            this.DependsAs = dependsAs;
            this.DependsTo = dependsTo;
            Words = new List<Word>();
        }

        public void AddWord(Word w)
        {
            this.Words.Add(w);
            this.EndPos += w.CharLength;
        }
    }
}
