﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;
using ChaKi.Service.Database;
using NHibernate;

namespace ChaKi.Service.Annotation
{
    public class DocumentTagService
    {
        private Corpus m_Corpus;

        public DocumentTagService(Corpus cps)
        {
            m_Corpus = cps;
        }

        public void Load()
        {
            DBService dbs = DBService.Create(m_Corpus.DBParam);
            NHibernate.Cfg.Configuration cfg = dbs.GetConnection();
            ISessionFactory factory = cfg.BuildSessionFactory();
            using (ISession session = factory.OpenSession())
            {
                m_Corpus.DocumentTags.Clear();
                string qstr = "from DocumentTag dt where dt.Tag = 'Bib_ID'";
                IQuery query = session.CreateQuery(qstr);
                IList<DocumentTag> dtags = query.List<DocumentTag>();
                foreach (DocumentTag dtag in dtags)
                {
                    m_Corpus.DocumentTags.Add(dtag);
                }
            }
        }
    }
}
