﻿using System.Collections.Generic;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Search;

namespace ChaKi.Entity.Settings
{
    public class AttributeColorSetting
    {
        // 条件
        public bool IsUsed { get; set; }
        public LexemeCondition MatchingRule { get; set; }
        public int MinFrequency { get; set; }
        public int MaxFrequency { get; set; }

        // 条件に合った場合の色設定(Argb)
        public int BgColor { get; set; }
        public int FgColor { get; set; }


        public AttributeColorSetting()
        {
            this.IsUsed = false;
            this.MatchingRule = new LexemeCondition();
            this.MinFrequency = -1;
            this.MaxFrequency = -1;

            this.BgColor = 0;
            this.FgColor = 0;
        }
    }

    public class AttributeColorSettings
    {
        public AttributeColorSettings()
        {
            this.Settings = new List<AttributeColorSetting>();
        }

        public List<AttributeColorSetting> Settings { get; set; }
    }
}
