using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Search
{
    [Serializable]
    public struct Range
    {
        public Range(int start, int end)
        {
            this.Start = start;
            this.End = end;
        }
        public Range(Range org)
        {
            this.Start = org.Start;
            this.End = org.End;
        }

        public int Start;
        public int End;

        public void Reset()
        {
            Start = 0;
            End = 0;
        }

        public void Offset(int offset)
        {
            Start += offset;
            End += offset;
        }
    }
}
