﻿using System;
using System.Collections.Generic;
using System.Text;
using ChaKi.Entity.Corpora;

namespace ChaKi.Entity.Search
{
    public class CollocationCondition : ISearchCondition, ICloneable
    {
        public CollocationType CollType { get; set; }
        public int Lwsz { get; set; }
        public int Rwsz { get; set; }
        public LexemeFilter Filter { get; set; }

        public event EventHandler ModelChanged;


        public CollocationCondition()
        {
            Reset();
        }

        public CollocationCondition(CollocationCondition org)
        {
            this.CollType = org.CollType;
            this.Lwsz = org.Lwsz;
            this.Rwsz = org.Rwsz;
            this.Filter = new LexemeFilter(org.Filter);
        }

        public void Reset()
        {
            this.CollType = CollocationType.Raw;
            this.Lwsz = 5;
            this.Rwsz = 5;
            this.Filter = new LexemeFilter();
        }

        public object Clone()
        {
            return new CollocationCondition(this);
        }
    }
}
