using System;
using System.Collections;
using System.Text;
using System.Xml.Serialization;

namespace ChaKi.Entity.Corpora
{
    public class Word : IComparable
    {
        private static int sequentialOrderID = 0;

        public Word()
        {
            this.pos = sequentialOrderID++;
        }

        public int CompareTo(object obj)
        {
            if (obj is Word)
            {
                Word w = (Word)obj;
                return id.CompareTo(w.id);
            }
            throw new ArgumentException("object is not a Word");
        }


        private int id;
        private int pos;
        private int startChar;
        private int endChar;
        private DateTime timeStamp;

        private Sentence    sen;
        private Lexeme      lexeme;
        private Bunsetsu    bunsetsu;

        public static void ResetOrder()
        {
            sequentialOrderID = 0;
        }

        public virtual int ID
        {
            get { return id; }
            set { id = value; }
        }
        public virtual int Pos
        {
            get { return pos; }
            set { pos = value; }
        }
        public virtual int StartChar
        {
            get { return startChar; }
            set { startChar = value; }
        }
        public virtual int EndChar
        {
            get { return endChar; }
            set { endChar = value; }
        }

        public virtual Sentence Sen
        {
            get { return sen; }
            set { sen = value; }
        }
        public virtual Lexeme Lex
        {
            get { return lexeme; }
            set { lexeme = value; }
        }
        public virtual Bunsetsu Bunsetsu
        {
            get { return bunsetsu; }
            set { bunsetsu = value; }
        }

        public virtual int CharLength
        {
            get
            {
                if (this.lexeme != null)
                {
                    return this.lexeme.CharLength;
                }
                return 0;
            }
        }
    }
}
