using System;
using System.Collections;
using System.Text;
using System.Diagnostics;
using System.Xml.Serialization;
using Iesi.Collections.Generic;

namespace ChaKi.Entity.Corpora
{
    public class Sentence
    {
        public Sentence()
        {
            this.Words = new ArrayList();
            // WordCX^XOrder0ɖ߂
            // iWord.Order͕Pʂŕt^̂łj
            Word.ResetOrder();
            this.Bunsetsus = new ArrayList();
            this.DocumentTags = new HashedSet<DocumentTag>();
        }

        public Sentence(Document parentDoc)
            : this()
        {
            this.ParentDoc = parentDoc;
        }

        public virtual int ID { get; set; }

        /// <summary>
        /// Set of Words
        /// </summary>
        public virtual IList Words { get; set; }

        /// <summary>
        /// Set of Bunsetsu
        /// </summary>
        public virtual IList Bunsetsus { get; set; }

        public virtual Document ParentDoc { get; set; }

        public virtual int StartChar { get; set; }

        public virtual int EndChar { get; set; }

        public virtual ISet<DocumentTag> DocumentTags { get; set; }

        public virtual Word AddWord(Lexeme m)
        {
            Word seq = new Word();
            seq.Lex = m;
            seq.Sen = this;
            this.Words.Add(seq);
            return seq;
        }

        /// <summary>
        /// SentenceɑΉii.e. StartChar-EndCharԂ́jText\𓾂.
        /// </summary>
        /// <returns></returns>
        public virtual string GetText()
        {
            return this.ParentDoc.Text.Substring(this.StartChar, this.EndChar-this.StartChar);
        }

        /// <summary>
        /// CabochatH[}bg̕߃^OBunsetsuIuWFNg쐬A
        /// Sentenceɓo^B
        /// ׂĂ̕߂AEOS_CheckBunsetsusĂяoāA
        /// KvB
        /// </summary>
        /// <param name="s"></param>
        public virtual Bunsetsu AddBunsetsu(string s)
        {
            char[] bunsetsuSplitPattern = new char[] { ' ' };
            char[] numberPattern = new char[] { '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' };

            // "* 0 -D 0/0 0.00000000"̌`̍sp[X
            string[] bunsetsuparams = s.Split(bunsetsuSplitPattern);
            if (bunsetsuparams.Length < 3)
            {
                return null;
            }
            int bunsetsuId = -1;
            int depBunsetsuId = -1;
            string depType = null;
            try
            {
                bunsetsuId = Int32.Parse(bunsetsuparams[1]);
                int pos = bunsetsuparams[2].LastIndexOfAny(numberPattern);
                if (pos < 0 || pos + 1 > bunsetsuparams[2].Length - 1)
                {
                    return null;
                }
                depBunsetsuId = Int32.Parse(bunsetsuparams[2].Substring(0, pos + 1));
                depType = bunsetsuparams[2].Substring(pos + 1, bunsetsuparams[2].Length - pos - 1);

                // p[^΁A߃IuWFNg쐬ASetnenceɒǉo^
                if (bunsetsuId >= 0 && depType != null)
                {
                    int newsize = Math.Max(bunsetsuId, depBunsetsuId) + 1;
                    if (this.Bunsetsus.Count < newsize)
                    {
                        // Bunsetsuszg
                        for (int i = this.Bunsetsus.Count; i < newsize; i++)
                        {
                            this.Bunsetsus.Add(new Bunsetsu());
                        }
                    }
                    Bunsetsu ph = this.Bunsetsus[bunsetsuId] as Bunsetsu;
                    ph.Pos = bunsetsuId;
                    ph.Sen = this;
                    if (depBunsetsuId >= 0)
                    {
                        ph.DependsTo = this.Bunsetsus[depBunsetsuId] as Bunsetsu;
                    }
                    ph.DependsAs = depType;
                    return ph;
                }
            }
            catch (Exception)
            {
                return null;
            }
            return null;
        }


        /// <summary>
        /// ߃f[^̐B
        /// ̓Iɂ́A
        /// E߂܂ЂƂȂ΁AftHg߂P쐬AׂĂWordɑ悤ɂB
        /// 
        /// Eɋ̕߂P쐬ADependsTo==null̕߂ɌW悤ɂB
        /// </summary>
        public virtual void CheckBunsetsus()
        {
            if (this.Bunsetsus.Count == 0)
            {
                Bunsetsu defaultBunsetsu = new Bunsetsu();
                defaultBunsetsu.Pos = 0;
                defaultBunsetsu.Sen = this;
                this.Bunsetsus.Add(defaultBunsetsu);
                foreach (Word w in this.Words)
                {
                    w.Bunsetsu = defaultBunsetsu;
                }
            }
            Bunsetsu lastBunsetsu = new Bunsetsu();
            lastBunsetsu.Pos = this.Bunsetsus.Count;
            lastBunsetsu.Sen = this;
            this.Bunsetsus.Add(lastBunsetsu);

            foreach (Bunsetsu b in this.Bunsetsus)
            {
                if (b != lastBunsetsu && b.DependsTo == null)
                {
                    b.DependsTo = lastBunsetsu;
                }
            }

            for (int i = 0; i < this.Bunsetsus.Count; i++)
            {
                Debug.Assert(((Bunsetsu)this.Bunsetsus[i]).Pos == i);
            }
        }

        /// <summary>
        /// w肵̌ŕ߂Qɕ.
        /// </summary>
        /// <param name="bunsetsuPos">̕ߔԍ(Bunsetsu.Pos)</param>
        /// <param name="wordPos">̌ԍ(Word.Pos)</param>
        public virtual Bunsetsu SplitBunsetsu(int bunsetsuPos, int wordPos)
        {
            // Ώە
            Bunsetsu b_src = null;
            // ߔԍbunsetsuPos傫߂̔ԍׂ+1
            foreach (Bunsetsu b in this.Bunsetsus)
            {
                if (b.Pos > bunsetsuPos)
                {
                    b.Pos++;
                }
                if (b.Pos == bunsetsuPos) {
                    b_src = b;
                }
            }
            Trace.Assert( b_src != null );

            // V߂𕶐ߔԍ=bunsetsuPos+1Ƃč쐬
            Bunsetsu b_new = new Bunsetsu();
            b_new.Sen = this;
            b_new.Pos = bunsetsuPos + 1;
            b_new.DependsTo = b_src.DependsTo;
            b_new.DependsAs = b_src.DependsAs;
            this.Bunsetsus.Insert(bunsetsuPos+1, b_new);
            b_src.DependsTo = b_new;

            // ߂̕_ȍ~ׂ̂Ă̌V߂Ɋ蓖ĂȂ
            foreach (Word w in this.Words)
            {
                if (w.Bunsetsu == b_src && w.Pos > wordPos)
                {
                    w.Bunsetsu = b_new;
                }
            }

            // ǉꂽ߂ԂB
            return b_new;
        }

        /// <summary>
        /// w肵ʒu̕߂Ƃ̉E̕߂𕹍B
        /// </summary>
        /// <param name="bunsetsuPos"></param>
        public virtual Bunsetsu MergeBunsetsu(int bunsetsuPos)
        {
            if (bunsetsuPos < 0 || bunsetsuPos >= this.Bunsetsus.Count-1)
            {
                return null;
            }
            Bunsetsu b_merging = (Bunsetsu)this.Bunsetsus[bunsetsuPos];
            Bunsetsu b_merged = (Bunsetsu)this.Bunsetsus[bunsetsuPos+1];

            // w肵ʒủEɂ镶߂폜
            this.Bunsetsus.RemoveAt(bunsetsuPos + 1);
            // ߔԍbunsetsuPos傫߂̔ԍׂ-1
            foreach (Bunsetsu b in this.Bunsetsus)
            {
                if (b.Pos > bunsetsuPos)
                {
                    b.Pos--;
                }
            }

            // }[WĎc镶߂̌WA폜߂̌WɕύX
            b_merging.DependsTo = b_merged.DependsTo;
            // 폜߂ւ̌Wׂă}[W̕߂ɕύX
            foreach (Bunsetsu b in this.Bunsetsus)
            {
                if (b.DependsTo == b_merged)
                {
                    b.DependsTo = b_merging;
                }
            }
            // 폜߂ɑĂWordׂă}[W̕߂ɕύX
            foreach (Word w in this.Words)
            {
                if (w.Bunsetsu == b_merged)
                {
                    w.Bunsetsu = b_merging;
                }
            }

            // 폜ꂽ߂ԂB
            return b_merged;
        }
    }
}
