using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora
{
    public class Lexicon
    {
        public List<Lexeme> Entries { get; set; }
        public List<PartOfSpeech> PartsOfSpeech { get; set; }
        public List<CType> CTypes { get; set; }
        public List<CForm> CForms { get; set; }

        public Lexicon()
        {
            this.Entries = new List<Lexeme>();
            this.PartsOfSpeech = new List<PartOfSpeech>();
            this.CTypes = new List<CType>();
            this.CForms = new List<CForm>();
        }

        public void Reset()
        {
            this.Entries.Clear();
            this.PartsOfSpeech.Clear();
            this.CTypes.Clear();
            this.CForms.Clear();
        }
        
        /// <summary>
        /// `LexemeTBȂΓo^(?)
        /// </summary>
        /// <param name="surface"></param>
        /// <param name="pos"></param>
        /// <param name="ct"></param>
        /// <param name="cf"></param>
        /// <returns></returns>
        public Lexeme GetBaseLexeme(string s)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// Entries𑮐̂ꂩɂă\[g
        /// </summary>
        /// <param name="lp"></param>
        /// <param name="isAscending"></param>
        public void Sort(int keyIndex, bool isAscending)
        {
            Lexeme.CompareKey = keyIndex;
            Lexeme.CompareAscending = isAscending;
            this.Entries.Sort();
        }
    }
}
