﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ChaKi.Entity.Corpora
{
    public class LexemeFilter : IEqualityComparer<Lexeme>
    {
        private Dictionary<LP, bool> m_Filters;

        public LexemeFilter()
        {
            m_Filters = new Dictionary<LP, bool>();
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                m_Filters.Add(tag, false);
            }
        }

        public LexemeFilter(LexemeFilter org)
        {
            m_Filters = new Dictionary<LP, bool>();
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                m_Filters.Add(tag, org.m_Filters[tag]);
            }
        }

        public List<string> GetUnfilteredPropertyNames()
        {
            List<string> result = new List<string>();
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                if (!IsFiltered(tag))
                {
                    result.Add(Lexeme.PropertyName[tag]);
                }
            }
            return result;
        }

        public bool IsFiltered(LP lp)
        {
            return m_Filters[lp];
        }

        public void SetFiltered(LP lp)
        {
            m_Filters[lp] = true;
        }

        public void ResetFiltered(LP lp)
        {
            m_Filters[lp] = false;
        }

        public void Reset()
        {
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                m_Filters[tag] = false;
            }
        }

        public bool Equals(Lexeme x, Lexeme y)
        {
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                if (!m_Filters[tag])
                {
                    if (!x.GetStringProperty(tag).Equals(y.GetStringProperty(tag)))
                    {
                        return false;
                    }
                }
            }
            return true;
        }

        public int GetHashCode(Lexeme lex)
        {
            int hash = 0;
            foreach (LP tag in Lexeme.PropertyName.Keys)
            {
                if (!m_Filters[tag])
                {
                    hash += lex.GetStringProperty(tag).GetHashCode();
                }
            }
            return hash;
        }
    }
}
