﻿
namespace ChaKi.Entity.Corpora
{
    public class CharRange
    {
        public CharPos Start;
        public CharPos End;

        public CharRange()
        {
            Start = new CharPos();
            End = new CharPos();
        }

        public CharRange(CharPos s, CharPos e)
        {
            Start = s;
            End = e;
        }

        public void Clear()
        {
            Start = null;
            End = null;
        }

        public int Length
        {
            get { return End.CharID - Start.CharID; }
        }

        public bool Valid
        {
            get
            {
                return (Start != null && End != null);
            }
        }

        public CharRange ToAscendingRange()
        {
            if (!Valid)
            {
                CharRange erange = new CharRange();
                return erange;
            }
            if (Start.WordID > End.WordID)
            {
                // Swap Start/End
                CharRange rrange = new CharRange(End, Start);
                return rrange;
            }
            else if (Start.WordID == End.WordID)
            {
                if (Start.CharInWord > End.CharInWord)
                {
                    // Swap Start/End
                    CharRange rrange = new CharRange(End, Start);
                    return rrange;
                }
            }
            CharRange range = new CharRange(Start, End);
            return range;
        }

        public bool IsEmpty
        {
            get
            {
                if (Start == null || End == null) return true;
                return (Start.WordID == End.WordID && Start.CharInWord == End.CharInWord);
            }
        }
    }
}
