﻿using System.Collections.Generic;
using ChaKi.Entity.Corpora;
using ChaKi.Entity.Search;

namespace ChaKi.Entity.Collocation
{
    public class CollocationList
    {
        public Dictionary<Lexeme, List<DIValue>> Rows { get; set; }
        public int NColumns { get; set; }
        public List<string> ColumnTitles { get; set; }
        public List<bool> ColumnIsDouble { get; set; }
        public List<bool> ColumnHasTotal { get; set; }
        public CollocationCondition Cond { get; set; }

        public CollocationList(CollocationCondition cond)
        {
            this.Cond = new CollocationCondition(cond);  // 条件はこれ以降編集されて変更される場合があるので、コピーを保持する。
            this.Rows = new Dictionary<Lexeme, List<DIValue>>(new LexemeEqualityComparer());
            this.ColumnTitles = new List<string>();
            this.ColumnIsDouble = new List<bool>();
            this.ColumnHasTotal = new List<bool>();
        }

        public List<DIValue> FindRow(Lexeme key)
        {
            List<DIValue> row = null;
            if (!this.Rows.TryGetValue(key, out row))
            {
                row = new List<DIValue>();
                for (int i = 0; i < this.NColumns; i++)
                {
                    row.Add(new DIValue());
                }
                this.Rows.Add(key, row);
            }
            return row;
        }
    }
}
