﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using ChaKi.Common;
using System.Drawing;

namespace ChaKi.Views.KwicView
{
    public class Caret
    {
        private IntPtr m_OwnerHandle;
        private bool m_Visible;

        public Caret(Control parent)
        {
            m_OwnerHandle = parent.Handle;
        }

        public void Create(int height)
        {
            NativeFunctions.CreateCaret(m_OwnerHandle, IntPtr.Zero, 1, height);
            this.Location = new Point(200, 200);// Point.Empty;
            this.Visible = true;
        }

        public Point Location {
            set {
                NativeFunctions.SetCaretPos(value.X, value.Y);
            }
        }

        public bool Visible
        {
            set
            {
                if (value)
                {
                    NativeFunctions.ShowCaret(m_OwnerHandle);
                }
                else
                {
                    NativeFunctions.HideCaret(m_OwnerHandle);
                }
                m_Visible = value;
            }
            get
            {
                return m_Visible;
            }
        }

    }
}
