﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;
using ChaKi.VirtualGrid;
using ChaKi.Entity.Corpora;
using System.Collections;
using ChaKi.Common;
using ChaKi.Service.Database;

namespace ChaKi.ToolDialogs
{
    public partial class CorpusInfo : Form
    {
        private Corpus m_Corpus;
        private Cache m_MemoryCache;
        private bool m_Closed;

        public CorpusInfo()
        {
            InitializeComponent();
            m_Corpus = null;
            m_Closed = false;

            this.dataGridView2.VirtualMode = true;
            this.dataGridView2.CellValueNeeded += new DataGridViewCellValueEventHandler(dataGridView2_CellValueNeeded);
            this.dataGridView2.ColumnHeaderMouseClick += new DataGridViewCellMouseEventHandler(dataGridView2_ColumnHeaderMouseClick);
        }

        public void LoadCorpusInfo(Corpus c)
        {
            // コーパスの基本情報をロードする
            m_Corpus = c;
            DBService dbs = DBService.Create(c.DBParam);
            Application.DoEvents();
            Cursor oldCur = this.Cursor;
            this.Cursor = Cursors.WaitCursor;
            // Lexicon以外の情報→同期式
            try
            {
                dbs.LoadCorpusInfo(c);
            }
            catch (Exception ex)
            {
                ExceptionDialogBox dlg = new ExceptionDialogBox();
                dlg.Text = ex.ToString();
                dlg.ShowDialog();
                return;
            }
            Application.DoEvents();

            // Lexicon情報→非同期
            this.backgroundWorker1.RunWorkerAsync();

            ShowSummary();
            ShowSegmentTags();
            ShowLinkTags();
            ShowGroupTags();
            this.Cursor = oldCur;
        }

        private void ShowSummary()
        {
            IList<CorpusProperty> cprops = m_Corpus.GetCorpusProperties();
            this.dataGridView1.DataSource = cprops;
            this.dataGridView1.Columns[0].Width = 100;
            this.dataGridView1.Columns[1].Width = 300;
        }

        private void ShowLexicon()
        {
            Lexicon lexicon = m_Corpus.Lex;
            DataGridView dg = this.dataGridView2;

            // 内容のupdateはVirtualGridのon-demand updateに任せる
            dg.RowCount = m_Corpus.Lex.Entries.Count;
        }

        private void ShowPOS()
        {
            this.propertyTree1.Cps = m_Corpus;
            this.propertyTree1.PopulateWithPOSSelections();
        }
        private void ShowCForms()
        {
            this.propertyTree2.Cps = m_Corpus;
            this.propertyTree2.PopulateWithCFormSelections();
        }
        private void ShowCTypes()
        {
            this.propertyTree3.Cps = m_Corpus;
            this.propertyTree3.PopulateWithCTypeSelections();
        }
        private void ShowSegmentTags()
        {
            //@todo
            DataGridView dg = this.dataGridView3;
            dg.RowCount++;
            dg[0, 0].Value = "Bunsetsu";
        }
        private void ShowLinkTags()
        {
            //@todo
            DataGridView dg = this.dataGridView4;
            dg.RowCount++;
            dg[0, 0].Value = "D";
            dg[1, 0].Value = "Bunsetsu";
            dg[2, 0].Value = "Bunsetsu";
            dg[3, 0].Value = true;
            dg[4, 0].Value = false;
            dg.RowCount++;
            dg[0, 1].Value = "A";
            dg[1, 1].Value = "Bunsetsu";
            dg[2, 1].Value = "Bunsetsu";
            dg[3, 1].Value = true;
            dg[4, 1].Value = false;
            dg.RowCount++;
            dg[0, 2].Value = "O";
            dg[1, 2].Value = "Bunsetsu";
            dg[2, 2].Value = "Bunsetsu";
            dg[3, 2].Value = true;
            dg[4, 2].Value = false;
        }
        private void ShowGroupTags()
        {
        }

        private void backgroundWorker1_DoWork(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            DBService dbs = DBService.Create(m_Corpus.DBParam);
            try
            {
                dbs.LoadLexicon(m_Corpus);
            }
            catch (Exception ex)
            {
                ExceptionDialogBox dlg = new ExceptionDialogBox();
                dlg.Text = ex.ToString();
                dlg.ShowDialog();
                return;
            }
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, System.ComponentModel.RunWorkerCompletedEventArgs e)
        {
            if (m_Closed)
            {
                return;
            }
            ShowLexicon();
            ShowPOS();
            ShowCForms();
            ShowCTypes();
            this.labelLoading.Visible = false;
            this.tabControl2.Visible = true;
        }

        private void dataGridView2_CellValueNeeded(object sender, DataGridViewCellValueEventArgs e)
        {
            Lexeme lex = null;
            try
            {
                lex = m_Corpus.Lex.Entries[e.RowIndex];
            }
            catch (Exception)
            {
                return;
            }

            switch (e.ColumnIndex)
            {
                case 0: e.Value = lex.Surface; break;
                case 1: e.Value = lex.Reading; break;
                case 2: e.Value = lex.Pronunciation; break;
                case 3: e.Value = (lex.BaseLexeme != null) ? lex.BaseLexeme.Surface : ""; break;
                case 4: e.Value = lex.PartOfSpeech.Name; break;
                case 5: e.Value = lex.CType.Name; break;
                case 6: e.Value = lex.CForm.Name; break;
                case 7: e.Value = lex.Frequency; break;
            }
            //            e.Value = this.m_MemoryCache.RetrieveElement(e.RowIndex, e.ColumnIndex);
        }

        private void dataGridView2_ColumnHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            int colno = e.ColumnIndex;
            // colno以外のGryphを消し、colnoのGryphを反転させる
            SortOrder order = this.dataGridView2.Columns[colno].HeaderCell.SortGlyphDirection;
            foreach (DataGridViewColumn col in this.dataGridView2.Columns)
            {
                col.HeaderCell.SortGlyphDirection = SortOrder.None;
            }
            if (order == SortOrder.Ascending)
            {
                this.dataGridView2.Columns[colno].HeaderCell.SortGlyphDirection = SortOrder.Descending;
            }
            else
            {
                this.dataGridView2.Columns[colno].HeaderCell.SortGlyphDirection = SortOrder.Ascending;
            }
            order = this.dataGridView2.Columns[colno].HeaderCell.SortGlyphDirection;

            Cursor oldCur = this.Cursor;
            this.Cursor = Cursors.WaitCursor;
            m_Corpus.Lex.Sort(colno, (order == SortOrder.Ascending) );
            this.Cursor = oldCur;

            this.dataGridView2.Invalidate();
        }

        private void CorpusInfo_FormClosing(object sender, FormClosingEventArgs e)
        {
            m_Closed = true;
        }
    }
}
