﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Threading;
using System.Diagnostics;
using ChaKi.Common;
using ChaKi.Entity.Kwic;

namespace ChaKi
{
    public partial class SentenceListView : UserControl, IChaKiView
    {
        public KwicList Model
        {
            get { return m_Model; }
        }
        private KwicList m_Model;
        private bool m_bNotify;

        private System.Threading.Timer m_Timer;      // 描画更新タイマ

        // 独自に管理する列ソート情報
        private DataGridViewColumn m_KwicSortedColumn = null;
        private SortOrder m_KwicSortOrder;

        private const int m_nHeader = 7;
        private static string[] m_HeaderText = new string[7] {
            "Index", "Check", "Corpus", "Char", "Sen",
            "Text", "Bib" };
        private static int[] m_HeaderWidth = new int[7] {
            37, 24, 100, 44, 44,
            350, 23 };
        private static DataGridViewColumn[] m_ColumnObjects = new DataGridViewColumn[7] {
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewCheckBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn(),
                new System.Windows.Forms.DataGridViewTextBoxColumn()
        };

        public SentenceListView()
        {
            m_bNotify = false;
            m_Model = null;

            this.InitializeComponent();

            this.dataGridView1.ReadOnly = false;
            // セルの背景色
            this.dataGridView1.RowTemplate.DefaultCellStyle.BackColor = Color.Linen;

            // 列の設定
            this.dataGridView1.Columns.AddRange(m_ColumnObjects);
            m_ColumnObjects[5].DefaultCellStyle.WrapMode = DataGridViewTriState.True;

            // 列ヘッダの設定
            for (int i = 0; i < m_nHeader; i++)
            {
                this.dataGridView1.Columns[i].Name = m_HeaderText[i];
                this.dataGridView1.Columns[i].Width = m_HeaderWidth[i];
            }

            // 列を非表示にする方法：
            //            this.Columns[0].Visible = false;

            // その他の設定
            this.dataGridView1.BorderStyle = BorderStyle.None;
            this.dataGridView1.RowHeadersVisible = false;
            this.dataGridView1.BackgroundColor = System.Drawing.SystemColors.ControlDark;
            this.dataGridView1.AllowUserToAddRows = false;
            this.dataGridView1.EditMode = DataGridViewEditMode.EditOnF2;
            this.dataGridView1.CellBorderStyle = DataGridViewCellBorderStyle.Single;
            this.dataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect;
            this.dataGridView1.ColumnHeadersDefaultCellStyle.Font = new System.Drawing.Font("Lucida Sans Unicode", 8F);
            this.dataGridView1.GridColor = System.Drawing.SystemColors.Control;
            this.dataGridView1.RowCount = 0;
            this.dataGridView1.AutoSizeRowsMode = DataGridViewAutoSizeRowsMode.DisplayedCellsExceptHeaders;

            this.dataGridView1.AutoResizeRows();

            // 描画更新タイマ
            TimerCallback timerDelegate = new TimerCallback(this.OnTimer);
            m_Timer = new System.Threading.Timer(timerDelegate, null, 1000, 1000);
        }

        public void SetModel(object model)
        {
            if (model != null && !(model is KwicList))
            {
                throw new ArgumentException("Assigning invalid model to SentenceListPanel");
            }
            // Modelの割り当てとUpdate受信初期化
            m_Model = (KwicList)model;
            if (m_Model != null)
            {
                m_Model.OnModelChanged += new UpdateKwicListEventHandler(this.ModelChangedHandler);
                // Clear all
                this.dataGridView1.Rows.Clear();
                this.dataGridView1.RowCount = m_Model.Records.Count;
            }
        }

        public void SetVisible(bool f)
        {
            this.Visible = f;
        }

        void ModelChangedHandler(object sender, EventArgs e)
        {
            m_bNotify = true;
        }

        delegate void SetCountDelegate(int count);
        public void SetCount(int count)
        {
            if (count == 0)
            {
                // Clear all
                this.dataGridView1.Rows.Clear();
            }
            else
            {
                int r0 = this.dataGridView1.RowCount;
                this.dataGridView1.RowCount = count;
                for (int r = r0; r < count; r++)
                {
                    this.dataGridView1[5, r].Value = m_Model.Records[r].Right.Words[0].Text;
                }
//                this.dataGridView1.AutoResizeRows();
            }
        }

        void OnTimer(object obj)
        {
            if (m_Model == null)
            {
                return;
            }
            if (m_bNotify)
            {
                try
                {
                    this.Invoke(new SetCountDelegate(SetCount), new object[] { m_Model.Records.Count });
                }
                catch (Exception e)
                {
                    Debug.WriteLine(e);
                }
                m_bNotify = false;
            }
        }
    }
}
