using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using ChaKi.Entity.Search;
using ChaKi.Common;

namespace ChaKi.Panels.ConditionsPanes
{
    public partial class FilterPane : UserControl
    {
        private FilterCondition m_Model;
        private DocumentFilterListDialog m_DocFilterDlg;

        public FilterPane(FilterCondition model)
        {
            m_Model = model;
            m_Model.OnModelChanged += new EventHandler( this.ModelChangedHandler );

            InitializeComponent();

            UpdateView();
        }

        public void SetCondition(FilterCondition cond)
        {
            m_Model = cond;
            m_Model.OnModelChanged += new EventHandler(this.ModelChangedHandler);
            UpdateView();
        }

        private void UpdateView()
        {

        }

        public void ModelChangedHandler(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// DocumentFilterTag̑IXg|bvAbv
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void textBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (m_DocFilterDlg == null)
            {
                m_DocFilterDlg = new DocumentFilterListDialog();
                Cursor oldCur = this.Cursor;
                this.Cursor = Cursors.WaitCursor;
                m_DocFilterDlg.LoadTags();
                this.Cursor = oldCur;
            }
            m_DocFilterDlg.Location = PointToScreen(new Point(this.textBox1.Left, this.textBox1.Bottom));
            if (m_DocFilterDlg.ShowDialog() == DialogResult.OK)
            {
                this.textBox1.Text = m_DocFilterDlg.SelectedValue;
            }
        }
    }
}
