﻿using System;
using System.Windows.Forms;
using ChaKi.Entity.Search;
using ChaKi.Entity.Corpora;

namespace ChaKi.Panels.ConditionsPanes
{
    public partial class CollocationPane : UserControl
    {
        private CollocationCondition m_Model;

        public CollocationPane(CollocationCondition model)
        {
            InitializeComponent();

            this.listBox1.Items.Clear();
            foreach (string tag in Lexeme.PropertyName.Values)
            {
                this.listBox1.Items.Add(tag);
            }
            SetCondition(model);
        }

        public void SetCondition(CollocationCondition cond)
        {
            m_Model = cond;
            m_Model.ModelChanged += new EventHandler(this.OnModelChanged);
            UpdateView();
        }

        public CollocationCondition GetCondition()
        {
            Synchronize();
            return m_Model;
        }

        /// <summary>
        /// 現在のModelの内容によってControl表示内容を更新する。
        /// </summary>
        private void UpdateView()
        {
            this.comboBox1.SelectedIndex = (int)m_Model.CollType;
            this.numericUpDown1.Value = m_Model.Lwsz;
            this.numericUpDown2.Value = m_Model.Rwsz;

            this.listBox1.ClearSelected();
            for (int i = 0; i < Lexeme.PropertyName.Count; i++)
            {
                if (!m_Model.Filter.IsFiltered((LP)i))
                {
                    this.listBox1.SelectedIndices.Add(i);
                }
            }
        }

        /// <summary>
        /// 現在のControlの状態によってModel内容を更新する。
        /// </summary>
        private void Synchronize()
        {
            m_Model.CollType = (CollocationType)this.comboBox1.SelectedIndex;
            m_Model.Lwsz = (int)this.numericUpDown1.Value;
            m_Model.Rwsz = (int)this.numericUpDown2.Value;

            m_Model.Filter.Reset();
            for (int i = 0; i < Lexeme.PropertyName.Count; i++)
            {
                if (!this.listBox1.SelectedIndices.Contains(i))
                {
                    m_Model.Filter.SetFiltered((LP)i);
                }
            }
        }

        void OnModelChanged(object sender, EventArgs e)
        {
        }

        /// <summary>
        /// Handler for "Select All"
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < this.listBox1.Items.Count; i++)
            {
                this.listBox1.SelectedIndices.Add(i);
            }
        }

        /// <summary>
        /// Handler for "Clear All"
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            this.listBox1.ClearSelected();
        }
    }
}
